/** @file
  This file contains VER3 specific GPIO information

@copyright
  INTEL CONFIDENTIAL
  Copyright 2017 - 2018 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#include "MrcOemPlatform.h"
//#include <Uefi/UefiBaseType.h>
//#include <Library/DebugLib.h>
#include <Library/PchInfoLib.h>
#include <Library/GpioLib.h>
#include <Library/GpioNativeLib.h>
//#include <Library/GpioPrivateLib.h>
#include <Private/Library/GpioPrivateLib.h>
#include <Register/GpioRegsVer3.h>
#include <Register/PmcRegsVer3.h>
#include <Register/PchPcrRegs.h>
//#include <Pins/GpioPinsVer3.h>
#include <GpioPinsVer3.h>
//#include <Library/PreSiliconEnvDetectLib.h>

GLOBAL_REMOVE_IF_UNREFERENCED GPIO_GROUP_INFO mPchGpioGroupInfo[] = {
  {PID_GPIOCOM0, R_GPIO_VER3_PCH_GPIO_PCR_GPP_B_PAD_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_B_HOSTSW_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_B_GPI_IS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_B_GPI_IE, R_GPIO_VER3_PCH_GPIO_PCR_GPP_B_GPI_GPE_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_B_GPI_GPE_EN, R_GPIO_VER3_PCH_GPIO_PCR_GPP_B_SMI_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_B_SMI_EN, R_GPIO_VER3_PCH_GPIO_PCR_GPP_B_NMI_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_B_NMI_EN, R_GPIO_VER3_PCH_GPIO_PCR_GPP_B_PADCFGLOCK,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_B_PADCFGLOCKTX,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_B_PADCFG_OFFSET,   GPIO_VER3_PCH_GPIO_GPP_B_PAD_MAX},  // EHL PCH GPP_B
  {PID_GPIOCOM0, R_GPIO_VER3_PCH_GPIO_PCR_GPP_T_PAD_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_T_HOSTSW_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_T_GPI_IS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_T_GPI_IE, R_GPIO_VER3_PCH_GPIO_PCR_GPP_T_GPI_GPE_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_T_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_GPP_T_PADCFGLOCK,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_T_PADCFGLOCKTX,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_T_PADCFG_OFFSET,   GPIO_VER3_PCH_GPIO_GPP_T_PAD_MAX},  // EHL PCH GPP_T
  {PID_GPIOCOM0, R_GPIO_VER3_PCH_GPIO_PCR_GPP_G_PAD_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_G_HOSTSW_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_G_GPI_IS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_G_GPI_IE, R_GPIO_VER3_PCH_GPIO_PCR_GPP_G_GPI_GPE_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_G_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_GPP_G_PADCFGLOCK,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_G_PADCFGLOCKTX,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_G_PADCFG_OFFSET,   GPIO_VER3_PCH_GPIO_GPP_G_PAD_MAX},  // EHL PCH GPP_G
  {PID_GPIOCOM1, R_GPIO_VER3_PCH_GPIO_PCR_GPP_V_PAD_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_V_HOSTSW_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_V_GPI_IS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_V_GPI_IE, R_GPIO_VER3_PCH_GPIO_PCR_GPP_V_GPI_GPE_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_V_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_GPP_V_PADCFGLOCK,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_V_PADCFGLOCKTX,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_V_PADCFG_OFFSET,   GPIO_VER3_PCH_GPIO_GPP_V_PAD_MAX},  // EHL PCH GPP_V
  {PID_GPIOCOM1, R_GPIO_VER3_PCH_GPIO_PCR_GPP_H_PAD_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_H_HOSTSW_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_H_GPI_IS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_H_GPI_IE, R_GPIO_VER3_PCH_GPIO_PCR_GPP_H_GPI_GPE_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_H_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_GPP_H_PADCFGLOCK,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_H_PADCFGLOCKTX,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_H_PADCFG_OFFSET,   GPIO_VER3_PCH_GPIO_GPP_H_PAD_MAX},  // EHL PCH GPP_H
  {PID_GPIOCOM1, R_GPIO_VER3_PCH_GPIO_PCR_GPP_D_PAD_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_D_HOSTSW_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_D_GPI_IS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_D_GPI_IE, R_GPIO_VER3_PCH_GPIO_PCR_GPP_D_GPI_GPE_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_D_GPI_GPE_EN, R_GPIO_VER3_PCH_GPIO_PCR_GPP_D_SMI_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_D_SMI_EN, R_GPIO_VER3_PCH_GPIO_PCR_GPP_D_NMI_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_D_NMI_EN, R_GPIO_VER3_PCH_GPIO_PCR_GPP_D_PADCFGLOCK,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_D_PADCFGLOCKTX,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_D_PADCFG_OFFSET,   GPIO_VER3_PCH_GPIO_GPP_D_PAD_MAX},  // EHL PCH GPP_D
  {PID_GPIOCOM1, R_GPIO_VER3_PCH_GPIO_PCR_GPP_U_PAD_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_U_HOSTSW_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_U_GPI_IS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_U_GPI_IE, R_GPIO_VER3_PCH_GPIO_PCR_GPP_U_GPI_GPE_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_U_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_GPP_U_PADCFGLOCK,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_U_PADCFGLOCKTX,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_U_PADCFG_OFFSET,   GPIO_VER3_PCH_GPIO_GPP_U_PAD_MAX},  // EHL PCH GPP_U
  {PID_GPIOCOM1, R_GPIO_VER3_PCH_GPIO_PCR_VGPIO_PAD_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_VGPIO_HOSTSW_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_VGPIO_GPI_IS, R_GPIO_VER3_PCH_GPIO_PCR_VGPIO_GPI_IE, R_GPIO_VER3_PCH_GPIO_PCR_VGPIO_GPI_GPE_STS, R_GPIO_VER3_PCH_GPIO_PCR_VGPIO_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_VGPIO_PADCFGLOCK,   R_GPIO_VER3_PCH_GPIO_PCR_VGPIO_PADCFGLOCKTX,   R_GPIO_VER3_PCH_GPIO_PCR_VGPIO_PADCFG_OFFSET,   GPIO_VER3_PCH_GPIO_VGPIO_PAD_MAX},  // EHL PCH vGPIO
  {PID_GPIOCOM2, R_GPIO_VER3_PCH_GPIO_PCR_GPD_PAD_OWN,     R_GPIO_VER3_PCH_GPIO_PCR_GPD_HOSTSW_OWN,     R_GPIO_VER3_PCH_GPIO_PCR_GPD_GPI_IS,   R_GPIO_VER3_PCH_GPIO_PCR_GPD_GPI_IE,   R_GPIO_VER3_PCH_GPIO_PCR_GPD_GPI_GPE_STS,   R_GPIO_VER3_PCH_GPIO_PCR_GPD_GPI_GPE_EN,   NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_GPD_PADCFGLOCK,     R_GPIO_VER3_PCH_GPIO_PCR_GPD_PADCFGLOCKTX,     R_GPIO_VER3_PCH_GPIO_PCR_GPD_PADCFG_OFFSET,     GPIO_VER3_PCH_GPIO_GPD_PAD_MAX},    // EHL PCH GPD
  {PID_GPIOCOM3, R_GPIO_VER3_PCH_GPIO_PCR_CPU_PAD_OWN,     R_GPIO_VER3_PCH_GPIO_PCR_CPU_HOSTSW_OWN,     NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,                   NO_REGISTER_FOR_PROPERTY,                  NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_CPU_PADCFGLOCK,     R_GPIO_VER3_PCH_GPIO_PCR_CPU_PADCFGLOCKTX,     R_GPIO_VER3_PCH_GPIO_PCR_CPU_PADCFG_OFFSET,     GPIO_VER3_PCH_GPIO_CPU_PAD_MAX},    // EHL PCH CPU
  {PID_GPIOCOM3, R_GPIO_VER3_PCH_GPIO_PCR_GPP_S_PAD_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_S_HOSTSW_OWN,   NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,                   NO_REGISTER_FOR_PROPERTY,                  NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_GPP_S_PADCFGLOCK,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_S_PADCFGLOCKTX,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_S_PADCFG_OFFSET,   GPIO_VER3_PCH_GPIO_GPP_S_PAD_MAX},  // EHL PCH GPP_S
  {PID_GPIOCOM3, R_GPIO_VER3_PCH_GPIO_PCR_GPP_A_PAD_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_A_HOSTSW_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_A_GPI_IS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_A_GPI_IE, R_GPIO_VER3_PCH_GPIO_PCR_GPP_A_GPI_GPE_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_A_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_GPP_A_PADCFGLOCK,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_A_PADCFGLOCKTX,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_A_PADCFG_OFFSET,   GPIO_VER3_PCH_GPIO_GPP_A_PAD_MAX},  // EHL PCH GPP_A
  {PID_GPIOCOM3, R_GPIO_VER3_PCH_GPIO_PCR_VGPIO_3_PAD_OWN, R_GPIO_VER3_PCH_GPIO_PCR_VGPIO_3_HOSTSW_OWN, NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,                   NO_REGISTER_FOR_PROPERTY,                  NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_VGPIO_3_PADCFGLOCK, R_GPIO_VER3_PCH_GPIO_PCR_VGPIO_3_PADCFGLOCKTX, R_GPIO_VER3_PCH_GPIO_PCR_VGPIO_3_PADCFG_OFFSET, GPIO_VER3_PCH_GPIO_VGPIO_3_PAD_MAX},// EHL PCH VGPIO_3
  {PID_GPIOCOM4, R_GPIO_VER3_PCH_GPIO_PCR_GPP_C_PAD_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_C_HOSTSW_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_C_GPI_IS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_C_GPI_IE, R_GPIO_VER3_PCH_GPIO_PCR_GPP_C_GPI_GPE_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_C_GPI_GPE_EN, R_GPIO_VER3_PCH_GPIO_PCR_GPP_C_SMI_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_C_SMI_EN, R_GPIO_VER3_PCH_GPIO_PCR_GPP_C_NMI_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_C_NMI_EN, R_GPIO_VER3_PCH_GPIO_PCR_GPP_C_PADCFGLOCK,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_C_PADCFGLOCKTX,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_C_PADCFG_OFFSET,   GPIO_VER3_PCH_GPIO_GPP_C_PAD_MAX},  // EHL PCH GPP_C
  {PID_GPIOCOM4, R_GPIO_VER3_PCH_GPIO_PCR_GPP_F_PAD_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_F_HOSTSW_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_F_GPI_IS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_F_GPI_IE, R_GPIO_VER3_PCH_GPIO_PCR_GPP_F_GPI_GPE_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_F_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_GPP_F_PADCFGLOCK,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_F_PADCFGLOCKTX,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_F_PADCFG_OFFSET,   GPIO_VER3_PCH_GPIO_GPP_F_PAD_MAX},  // EHL PCH GPP_F
  {PID_GPIOCOM4, R_GPIO_VER3_PCH_GPIO_PCR_HVCMOS_PAD_OWN,  R_GPIO_VER3_PCH_GPIO_PCR_HVCMOS_HOSTSW_OWN,  NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,                   NO_REGISTER_FOR_PROPERTY,                  NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_HVCMOS_PADCFGLOCK,  R_GPIO_VER3_PCH_GPIO_PCR_HVCMOS_PADCFGLOCKTX,  R_GPIO_VER3_PCH_GPIO_PCR_HVCMOS_PADCFG_OFFSET,  GPIO_VER3_PCH_GPIO_HVCMOS_PAD_MAX}, // EHL PCH HVCMOS
  {PID_GPIOCOM4, R_GPIO_VER3_PCH_GPIO_PCR_GPP_E_PAD_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_E_HOSTSW_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_E_GPI_IS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_E_GPI_IE, R_GPIO_VER3_PCH_GPIO_PCR_GPP_E_GPI_GPE_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_E_GPI_GPE_EN, R_GPIO_VER3_PCH_GPIO_PCR_GPP_E_SMI_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_E_SMI_EN, R_GPIO_VER3_PCH_GPIO_PCR_GPP_E_NMI_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_E_NMI_EN, R_GPIO_VER3_PCH_GPIO_PCR_GPP_E_PADCFGLOCK,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_E_PADCFGLOCKTX,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_E_PADCFG_OFFSET,   GPIO_VER3_PCH_GPIO_GPP_E_PAD_MAX},  // EHL PCH GPP_E
  {PID_GPIOCOM4, R_GPIO_VER3_PCH_GPIO_PCR_JTAG_PAD_OWN,    R_GPIO_VER3_PCH_GPIO_PCR_JTAG_HOSTSW_OWN,    NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,                   NO_REGISTER_FOR_PROPERTY,                  NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_JTAG_PADCFGLOCK,    R_GPIO_VER3_PCH_GPIO_PCR_JTAG_PADCFGLOCKTX,    R_GPIO_VER3_PCH_GPIO_PCR_JTAG_PADCFG_OFFSET,    GPIO_VER3_PCH_GPIO_JTAG_PAD_MAX},   // EHL PCH JTAG
  {PID_GPIOCOM5, R_GPIO_VER3_PCH_GPIO_PCR_GPP_R_PAD_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_R_HOSTSW_OWN,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_R_GPI_IS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_R_GPI_IE, R_GPIO_VER3_PCH_GPIO_PCR_GPP_R_GPI_GPE_STS, R_GPIO_VER3_PCH_GPIO_PCR_GPP_R_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_GPP_R_PADCFGLOCK,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_R_PADCFGLOCKTX,   R_GPIO_VER3_PCH_GPIO_PCR_GPP_R_PADCFG_OFFSET,   GPIO_VER3_PCH_GPIO_GPP_R_PAD_MAX},  // EHL PCH GPP_R
  {PID_GPIOCOM5, R_GPIO_VER3_PCH_GPIO_PCR_SPI_PAD_OWN,     R_GPIO_VER3_PCH_GPIO_PCR_SPI_HOSTSW_OWN,     NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,                   NO_REGISTER_FOR_PROPERTY,                  NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              R_GPIO_VER3_PCH_GPIO_PCR_SPI_PADCFGLOCK,     R_GPIO_VER3_PCH_GPIO_PCR_SPI_PADCFGLOCKTX,     R_GPIO_VER3_PCH_GPIO_PCR_SPI_PADCFG_OFFSET,     GPIO_VER3_PCH_GPIO_SPI_PAD_MAX}     // EHL PCH SPI
};

/**
  This procedure will retrieve address and length of GPIO info table

  @param[out]  GpioGroupInfoTableLength   Length of GPIO group table

  @retval Pointer to GPIO group table

**/
CONST GPIO_GROUP_INFO*
GpioGetGroupInfoTable (
  OUT UINT32              *GpioGroupInfoTableLength
  )
{
  *GpioGroupInfoTableLength = ARRAY_SIZE (mPchGpioGroupInfo);
  return mPchGpioGroupInfo;
}

/**
  Get GPIO Chipset ID specific to PCH generation and series
**/
UINT32
GpioGetThisChipsetId (
  VOID
  )
{
  return GPIO_VER3_CHIPSET_ID;
}

/**
  This internal procedure will check if group is within DeepSleepWell.

  @param[in]  Group               GPIO Group

  @retval GroupWell               TRUE:  This is DSW Group
                                  FALSE: This is not DSW Group
**/
BOOLEAN
GpioIsDswGroup (
  IN  GPIO_GROUP         Group
  )
{
  if (Group == GPIO_VER3_GROUP_GPD) {
    return TRUE;
  } else {
    return FALSE;
  }
}


/**
  This procedure will perform special handling of GPP_A_12.

  @param[in]  None

  @retval None
**/
VOID
GpioA12SpecialHandling (
  VOID
  )
{
  return;
}

GLOBAL_REMOVE_IF_UNREFERENCED PCH_SBI_PID mGpioComSbiIds[] =
{
  PID_GPIOCOM0, PID_GPIOCOM1, PID_GPIOCOM2, PID_GPIOCOM3, PID_GPIOCOM4, PID_GPIOCOM5
};

/**
  This function provides GPIO Community PortIDs

  @param[out] NativePinsTable                Table with GPIO COMMx SBI PortIDs

  @retval     Number of communities
**/
UINT32
GpioGetComSbiPortIds (
  OUT PCH_SBI_PID    **GpioComSbiIds
  )
{
  *GpioComSbiIds = mGpioComSbiIds;
  return ARRAY_SIZE (mGpioComSbiIds);
}

GLOBAL_REMOVE_IF_UNREFERENCED GPIO_PAD mPchGpioStandbyStateMaskedPads[] =
{
  GPIO_VER3_JTAGX,
  GPIO_VER3_PRDYB,
  GPIO_VER3_PREQB,
  GPIO_VER3_CPU_TRSTB,
  GPIO_VER3_TRIGGER_IN,
  GPIO_VER3_TRIGGER_OUT
};

/**
  This function provides list of GPIO for which IO Standby State configuration
  has to be set as 'Masked'

  @param[out] GpioPadsList                Table with pads

  @retval      Number of pads
**/
UINT32
GpioGetDFxStandbyStateMaskedPadsList (
  OUT GPIO_PAD      **GpioPadsList
  )
{
  *GpioPadsList = mPchGpioStandbyStateMaskedPads;
  return ARRAY_SIZE (mPchGpioStandbyStateMaskedPads);
}

GLOBAL_REMOVE_IF_UNREFERENCED GPIO_GROUP_TO_GPE_MAPPING mPchGpioGroupToGpeMapping[] = {
  {GPIO_VER3_GROUP_GPP_A,   0, V_EHL_PCH_PMC_PWRM_GPIO_CFG_GPP_A,  V_GPIO_VER3_PCH_GPIO_PCR_MISCCFG_GPE0_GPP_A},
  {GPIO_VER3_GROUP_GPP_B,   0, V_EHL_PCH_PMC_PWRM_GPIO_CFG_GPP_B,  V_GPIO_VER3_PCH_GPIO_PCR_MISCCFG_GPE0_GPP_B},
  {GPIO_VER3_GROUP_GPP_C,   0, V_EHL_PCH_PMC_PWRM_GPIO_CFG_GPP_C,  V_GPIO_VER3_PCH_GPIO_PCR_MISCCFG_GPE0_GPP_C},
  {GPIO_VER3_GROUP_GPP_D,   0, V_EHL_PCH_PMC_PWRM_GPIO_CFG_GPP_D,  V_GPIO_VER3_PCH_GPIO_PCR_MISCCFG_GPE0_GPP_D},
  {GPIO_VER3_GROUP_GPP_E,   0, V_EHL_PCH_PMC_PWRM_GPIO_CFG_GPP_E,  V_GPIO_VER3_PCH_GPIO_PCR_MISCCFG_GPE0_GPP_E},
  {GPIO_VER3_GROUP_GPP_F,   0, V_EHL_PCH_PMC_PWRM_GPIO_CFG_GPP_F,  V_GPIO_VER3_PCH_GPIO_PCR_MISCCFG_GPE0_GPP_F},
  {GPIO_VER3_GROUP_GPP_G,   0, V_EHL_PCH_PMC_PWRM_GPIO_CFG_GPP_G,  V_GPIO_VER3_PCH_GPIO_PCR_MISCCFG_GPE0_GPP_G},
  {GPIO_VER3_GROUP_GPP_H,   0, V_EHL_PCH_PMC_PWRM_GPIO_CFG_GPP_H,  V_GPIO_VER3_PCH_GPIO_PCR_MISCCFG_GPE0_GPP_H},
  {GPIO_VER3_GROUP_GPP_R,   0, V_EHL_PCH_PMC_PWRM_GPIO_CFG_GPP_R,  V_GPIO_VER3_PCH_GPIO_PCR_MISCCFG_GPE0_GPP_R},
  {GPIO_VER3_GROUP_GPP_S,   0, V_EHL_PCH_PMC_PWRM_GPIO_CFG_GPP_S,  V_GPIO_VER3_PCH_GPIO_PCR_MISCCFG_GPE0_GPP_S},
  {GPIO_VER3_GROUP_GPP_T,   0, V_EHL_PCH_PMC_PWRM_GPIO_CFG_GPP_T,  V_GPIO_VER3_PCH_GPIO_PCR_MISCCFG_GPE0_GPP_T},
  {GPIO_VER3_GROUP_GPP_U,   0, V_EHL_PCH_PMC_PWRM_GPIO_CFG_GPP_U,  V_GPIO_VER3_PCH_GPIO_PCR_MISCCFG_GPE0_GPP_U},
  {GPIO_VER3_GROUP_GPP_V,   0, V_EHL_PCH_PMC_PWRM_GPIO_CFG_GPP_V,  V_GPIO_VER3_PCH_GPIO_PCR_MISCCFG_GPE0_GPP_V},
  {GPIO_VER3_GROUP_GPD,     0, V_EHL_PCH_PMC_PWRM_GPIO_CFG_GPD,    V_GPIO_VER3_PCH_GPIO_PCR_MISCCFG_GPE0_GPD},
  {GPIO_VER3_GROUP_VGPIO,   0, V_EHL_PCH_PMC_PWRM_GPIO_CFG_VGPIO,  V_GPIO_VER3_PCH_GPIO_PCR_MISCCFG_GPE0_VGPIO}
};
GLOBAL_REMOVE_IF_UNREFERENCED GPIO_GROUP_TO_GPE_MAPPING mPchA0GpioGroupToGpeMapping[] = {
  {GPIO_VER3_GROUP_GPP_A,   0, V_EHL_PCH_A0_PMC_PWRM_GPIO_CFG_GPP_A,  V_GPIO_VER3_PCH_A0_GPIO_PCR_MISCCFG_GPE0_GPP_A},
  {GPIO_VER3_GROUP_GPP_B,   0, V_EHL_PCH_A0_PMC_PWRM_GPIO_CFG_GPP_B,  V_GPIO_VER3_PCH_A0_GPIO_PCR_MISCCFG_GPE0_GPP_B},
  {GPIO_VER3_GROUP_GPP_C,   0, V_EHL_PCH_A0_PMC_PWRM_GPIO_CFG_GPP_C,  V_GPIO_VER3_PCH_A0_GPIO_PCR_MISCCFG_GPE0_GPP_C},
  {GPIO_VER3_GROUP_GPP_D,   0, V_EHL_PCH_A0_PMC_PWRM_GPIO_CFG_GPP_D,  V_GPIO_VER3_PCH_A0_GPIO_PCR_MISCCFG_GPE0_GPP_D},
  {GPIO_VER3_GROUP_GPP_E,   0, V_EHL_PCH_A0_PMC_PWRM_GPIO_CFG_GPP_E,  V_GPIO_VER3_PCH_A0_GPIO_PCR_MISCCFG_GPE0_GPP_E},
  {GPIO_VER3_GROUP_GPP_F,   0, V_EHL_PCH_A0_PMC_PWRM_GPIO_CFG_GPP_F,  V_GPIO_VER3_PCH_A0_GPIO_PCR_MISCCFG_GPE0_GPP_F},
  {GPIO_VER3_GROUP_GPP_G,   0, V_EHL_PCH_A0_PMC_PWRM_GPIO_CFG_GPP_G,  V_GPIO_VER3_PCH_A0_GPIO_PCR_MISCCFG_GPE0_GPP_G},
  {GPIO_VER3_GROUP_GPP_H,   0, V_EHL_PCH_A0_PMC_PWRM_GPIO_CFG_GPP_H,  V_GPIO_VER3_PCH_A0_GPIO_PCR_MISCCFG_GPE0_GPP_H},
  {GPIO_VER3_GROUP_GPP_R,   0, V_EHL_PCH_A0_PMC_PWRM_GPIO_CFG_GPP_R,  V_GPIO_VER3_PCH_A0_GPIO_PCR_MISCCFG_GPE0_GPP_R},
  {GPIO_VER3_GROUP_GPP_S,   0, V_EHL_PCH_A0_PMC_PWRM_GPIO_CFG_GPP_S,  V_GPIO_VER3_PCH_A0_GPIO_PCR_MISCCFG_GPE0_GPP_S},
  {GPIO_VER3_GROUP_GPP_T,   0, V_EHL_PCH_A0_PMC_PWRM_GPIO_CFG_GPP_T,  V_GPIO_VER3_PCH_A0_GPIO_PCR_MISCCFG_GPE0_GPP_T},
  {GPIO_VER3_GROUP_GPP_U,   0, V_EHL_PCH_A0_PMC_PWRM_GPIO_CFG_GPP_U,  V_GPIO_VER3_PCH_A0_GPIO_PCR_MISCCFG_GPE0_GPP_U},
  {GPIO_VER3_GROUP_GPP_V,   0, V_EHL_PCH_A0_PMC_PWRM_GPIO_CFG_GPP_V,  V_GPIO_VER3_PCH_A0_GPIO_PCR_MISCCFG_GPE0_GPP_V},
  {GPIO_VER3_GROUP_GPD,     0, V_EHL_PCH_A0_PMC_PWRM_GPIO_CFG_GPD,    V_GPIO_VER3_PCH_A0_GPIO_PCR_MISCCFG_GPE0_GPD},
  {GPIO_VER3_GROUP_VGPIO,   0, V_EHL_PCH_A0_PMC_PWRM_GPIO_CFG_VGPIO,  V_GPIO_VER3_PCH_A0_GPIO_PCR_MISCCFG_GPE0_VGPIO}
};
#ifndef MRC_MINIBIOS_BUILD
/**
  Get information for GPIO Group required to program GPIO and PMC for desired 1-Tier GPE mapping

  @param[out] GpioGroupToGpeMapping        Table with GPIO Group to GPE mapping
  @param[out] GpioGroupToGpeMappingLength  GPIO Group to GPE mapping table length
**/
VOID
GpioGetGroupToGpeMapping (
  OUT GPIO_GROUP_TO_GPE_MAPPING  **GpioGroupToGpeMapping,
  OUT UINT32                     *GpioGroupToGpeMappingLength
  )
{
  if ((!IsSimicsEnvironment ()) && (PchStepping () == PCH_A0)) {
    *GpioGroupToGpeMapping = mPchA0GpioGroupToGpeMapping;
    *GpioGroupToGpeMappingLength = ARRAY_SIZE (mPchA0GpioGroupToGpeMapping);
  } else {
    *GpioGroupToGpeMapping = mPchGpioGroupToGpeMapping;
    *GpioGroupToGpeMappingLength = ARRAY_SIZE (mPchGpioGroupToGpeMapping);
  }
}
#endif //MRC_MINIBIOS_BUILD
/**
  Check if 0x13 opcode supported for writing to GPIO lock unlock register

  @retval TRUE                It's supported
  @retval FALSE               It's not supported
**/
BOOLEAN
IsGpioLockOpcodeSupported (
  VOID
  )
{
  return TRUE;
}
