/**@file

@copyright
  INTEL CONFIDENTIAL
  Copyright 1999 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification
**/


// This ASL file will support the NCT6776F HW monitor.

Device(HWMN)  // Hw monitor.
{
  Name(_HID,EISAID("PNP0A05"))
  Name(_UID,2)

  // Status Method.

  Method(_STA,0,Serialized)
  {
    // Only report resources to the OS if the SIO Device is present.
    // Only Saddlebrook board has NCT6776F SIO.

    If(LEqual(NCTH,1))
    {
      Return(0x0F)
    }

    Return(0x00)
  }

  // Current Resource.

  Method(_CRS,0,Serialized)
  {
    Name(HMIO, ResourceTemplate()
    {
      IO(Decode16,0x0295,0x0296,1,2)
    })

    Return(HMIO)
  }
}
