#########################################################################################
#
#  ______      _                        _   _      _ _
# |  ____|    | |                      | | | |    (_) |
# | |__  __  _| |_ ___ _ __ _ __   __ _| | | |     _| |__  ___
# |  __| \ \/ / __/ _ \ '__| '_ \ / _` | | | |    | | '_ \/ __|
# | |____ >  <| ||  __/ |  | | | | (_| | | | |____| | |_) \__ \
# |______/_/\_\\__\___|_|  |_| |_|\__,_|_| |______|_|_.__/|___/
#
#
# all globally-relevant external libs should be defined as modules here, the definitions are then usable
# within any downstream components.
#
# Definitions here should include both the lib and any related paths (include paths) so that downstream modules
# do not need to hard-code such things.

# Ship the file that includes the licenses for all the thirdparty libs that we Ship
install(FILES "${OPENIPC_ROOT}/NOTICES"
        DESTINATION "${DPL_OPENIPC_ROOT}"
        COMPONENT openipc)
ShipSources(FILES "${OPENIPC_ROOT}/NOTICES")

set(CMAKE_THREAD_PREFER_PTHREAD TRUE)
set(THREADS_PREFER_PTHREAD_FLAG TRUE)
find_package(Threads REQUIRED)

############################################
#
# CRYPTO
#
set(CRYPTO_ROOT_DIR "${CRYPTO_ROOT}")
set(LIB_CRYPTO LIB_CRYPTO-NOTFOUND) # Force it to search again instead of using the cached value

if(WIN32)
    set(LIB_CRYPTO LIB_CRYPTOd-NOTFOUND)

    find_library(LIB_CRYPTO
                 NAMES libcrypto${CMAKE_STATIC_LIBRARY_SUFFIX}
                 PATHS "${CRYPTO_ROOT_DIR}/${SYSTEM_NAME}/${ARCHITECTURE_NAME}/release")

    find_library(LIB_SSL
                 NAMES libssl${CMAKE_STATIC_LIBRARY_SUFFIX}
                 PATHS "${CRYPTO_ROOT_DIR}/${SYSTEM_NAME}/${ARCHITECTURE_NAME}/release")

    find_library(LIB_CRYPTOd
                 NAMES libcrypto${CMAKE_STATIC_LIBRARY_SUFFIX}
                 PATHS "${CRYPTO_ROOT_DIR}/${SYSTEM_NAME}/${ARCHITECTURE_NAME}/debug")

    find_library(LIB_SSLd
                 NAMES libssl${CMAKE_STATIC_LIBRARY_SUFFIX}
                 PATHS "${CRYPTO_ROOT_DIR}/${SYSTEM_NAME}/${ARCHITECTURE_NAME}/debug")

    SET(CRYPTO_LIBRARIES optimized ${LIB_CRYPTO} debug ${LIB_CRYPTOd})
    SET(SSL_LIBRARIES optimized ${LIB_SSL} debug ${LIB_SSLd})

       message("INFO: using LIB_CRYPTO: ${LIB_CRYPTO}")
       message("INFO: using LIB_CRYPTOd: ${LIB_CRYPTOd}")
       message("INFO: using LIB_SSL: ${LIB_SSL}")
       message("INFO: using LIB_SSLd: ${LIB_SSLd}")

elseif(APPLE)
    find_library(LIB_CRYPTO
                 NAMES libcrypto${CMAKE_STATIC_LIBRARY_SUFFIX}
                 PATHS ${CRYPTO_ROOT_DIR}/${SYSTEM_NAME}/${ARCHITECTURE_NAME}
                 NO_DEFAULT_PATH
                 )
    find_library(LIB_SSL
                NAMES libssl${CMAKE_STATIC_LIBRARY_SUFFIX}
                PATHS ${CRYPTO_ROOT_DIR}/${SYSTEM_NAME}/${ARCHITECTURE_NAME}
                NO_DEFAULT_PATH)
    SET(CRYPTO_LIBRARIES general "${LIB_CRYPTO}")
    message("INFO: using using LIB_CRYPTO: ${LIB_CRYPTO}")
    SET(SSL_LIBRARIES general "${LIB_SSL}")
    message("INFO: using LIB_SSL: ${LIB_SSL}")
elseif(UNIX)
    find_library(LIB_CRYPTO
                 NAMES libcrypto${CMAKE_STATIC_LIBRARY_SUFFIX}
                 PATHS ${CRYPTO_ROOT_DIR}/${SYSTEM_NAME}/${ARCHITECTURE_NAME}
                                NO_SYSTEM_ENVIRONMENT_PATH NO_CMAKE_SYSTEM_PATH)
    find_library(LIB_SSL
                 NAMES libssl${CMAKE_STATIC_LIBRARY_SUFFIX}
                 PATHS ${CRYPTO_ROOT_DIR}/${SYSTEM_NAME}/${ARCHITECTURE_NAME}
                                NO_SYSTEM_ENVIRONMENT_PATH NO_CMAKE_SYSTEM_PATH)
    SET(CRYPTO_LIBRARIES general "${LIB_CRYPTO}")
    message("INFO: using LIB_CRYPTO: ${LIB_CRYPTO}")
    SET(SSL_LIBRARIES general "${LIB_SSL}")
    message("INFO: using LIB_SSL: ${LIB_SSL}")
endif()
SET(CRYPTO_INCLUDE "${CRYPTO_ROOT_DIR}")
ShipSources(DIRECTORIES "${CRYPTO_ROOT_DIR}")


############################################
#
# Xerces
#
set(XERCES_VERSION "3.2.2")
set(XERCES_ROOT_DIR "${THIRDPARTY_ROOT}/Xerces-C++/${XERCES_VERSION}")
set(LIB_xerces3 LIB_xerces3-NOTFOUND) # Force it to search again instead of using the cached value

if(WIN32)
    set(LIB_xerces3d LIB_xerces3d-NOTFOUND)

    find_library(LIB_xerces3
                 NAMES xerces-c_3${CMAKE_STATIC_LIBRARY_SUFFIX}
                 PATHS "${XERCES_ROOT_DIR}/${SYSTEM_NAME}/${ARCHITECTURE_NAME}/release")

    find_library(LIB_xerces3d
                 NAMES xerces-c_3D${CMAKE_STATIC_LIBRARY_SUFFIX}
                 PATHS "${XERCES_ROOT_DIR}/${SYSTEM_NAME}/${ARCHITECTURE_NAME}/debug")

    SET(XERCES_LIBRARIES optimized ${LIB_xerces3} debug ${LIB_xerces3d})

    message("INFO: using LIB_xerces3: ${LIB_xerces3}")
    message("INFO: using LIB_xerces3d: ${LIB_xerces3d}")

elseif(APPLE)
    find_library(LIB_xerces3
                 NAMES libxerces-c${CMAKE_STATIC_LIBRARY_SUFFIX}
                 PATHS ${XERCES_ROOT_DIR}/${SYSTEM_NAME}/${ARCHITECTURE_NAME}
                 NO_DEFAULT_PATH
                 )

    SET(XERCES_LIBRARIES general "${LIB_xerces3};-lobjc -lcurl -Wl,-framework,CoreFoundation -Wl,-framework,CoreServices")
    message("INFO: using LIB_xerces3: ${LIB_xerces3}")
elseif(UNIX)
    find_library(LIB_xerces3
                 NAMES libxerces-c${CMAKE_STATIC_LIBRARY_SUFFIX}
                 PATHS ${XERCES_ROOT_DIR}/${SYSTEM_NAME}/${ARCHITECTURE_NAME})

    SET(XERCES_LIBRARIES general ${LIB_xerces3})
    message("INFO: using LIB_xerces3: ${LIB_xerces3}")
endif()
SET(XERCES_INCLUDE_DIRS "${XERCES_ROOT_DIR}/include"
                        "${XERCES_ROOT_DIR}/${SYSTEM_NAME}/include")
ShipSources(SYSTEM_DIRECTORIES "${XERCES_ROOT_DIR}"
            DIRECTORIES "${XERCES_ROOT_DIR}/include"
            FILES "${XERCES_ROOT_DIR}/Building_On_UNIX.txt"
                  "${XERCES_ROOT_DIR}/Building_On_Windows.txt"
                  "${XERCES_ROOT_DIR}/LICENSE"
                  "${XERCES_ROOT_DIR}/xerces-c-${XERCES_VERSION}.zip")

############################################
#
# Python Interpreter (Executable)
#
# The following "Include" directive finds the python interpreter and sets the PYTHONINTERP_FOUND to TRUE or FALSE depending on whether it finds it or not.
# It also sets PYTHON_EXECUTABLE to the full path to the python interpreter so we can use it in custom build steps
INCLUDE(FindPythonInterp)

IF(NOT ${PYTHONINTERP_FOUND})
    MESSAGE(FATAL_ERROR "Python is not installed. Cannot run some custom build steps.")
ENDIF()

############################################
#
# Doxygen
#
# We should prefer the local copy of Doxygen that we have

set(CMAKE_PROGRAM_PATH "${OPENIPC_ROOT}/Tools/Doxygen/1.8.11/${SYSTEM_NAME}")
find_package(Doxygen)

if(NOT DOXYGEN_FOUND)
    message(WARNING "Doxygen not found. Build will not have documentation")
endif()
# Let's not ship Doxygen binaries because they're GPL
#ShipSources(DIRECTORIES "${OPENIPC_ROOT}/Tools/Doxygen")

# Ship the CMake binaries in a source release
ShipSources(SYSTEM_DIRECTORIES "${OPENIPC_ROOT}/Tools/CMake")

############################################
#
# Uncrustify
#
set(UNCRUSTIFY_CMD "${OPENIPC_ROOT}/Tools/Uncrustify/${SYSTEM_NAME}/uncrustify${CMAKE_EXECUTABLE_SUFFIX}")
set(UNCRUSTIFY_FOUND False)
if(EXISTS ${UNCRUSTIFY_CMD})
    set(UNCRUSTIFY_FOUND True)
endif()