############################################
#
# LibZip
#
set(LIBZIP_VERSION "1.5.1")
set(LIBZIP_ROOT ${THIRDPARTY_ROOT}/LibZip/${LIBZIP_VERSION})
set(LIBZIP_BIN_DIR "${LIBZIP_ROOT}/${SYSTEM_NAME}/${ARCHITECTURE_NAME}")
set(LIBZIP_INCLUDE_DIRS "${LIBZIP_ROOT}/include"
                        "${LIBZIP_ROOT}/${SYSTEM_NAME}/include")

set(LIB_zip LIB_zip-NOTFOUND) # Force it to search again instead of using the cached value

find_library(LIB_zip
         NAME  ${CMAKE_STATIC_LIBRARY_PREFIX}zip${CMAKE_STATIC_LIBRARY_SUFFIX}
         PATHS "${LIBZIP_BIN_DIR}")

mark_as_advanced(LIB_zip)

SET(LIBZIP_LIBRARIES ${LIB_zip})

ShipSources(SYSTEM_DIRECTORIES "${LIBZIP_ROOT}"
            DIRECTORIES "${LIBZIP_ROOT}/include"
            FILES "${LIBZIP_ROOT}/Building_On_Unix.txt"
                  "${LIBZIP_ROOT}/Building_On_Windows.txt"
                  "${LIBZIP_ROOT}/libzip-${LIBZIP_VERSION}.zip"
                  "${LIBZIP_ROOT}/LICENSE")
