############################################
#
# ZLib
#
set(ZLIB_VERSION "1.2.11")
set(ZLIB_ROOT "${THIRDPARTY_ROOT}/ZLib/${ZLIB_VERSION}")
set(ZLIB_BIN_DIR "${ZLIB_ROOT}/${SYSTEM_NAME}/${ARCHITECTURE_NAME}")
set(ZLIB_INCLUDE_DIR ${ZLIB_ROOT}/${SYSTEM_NAME}/include)

if (WIN32)
    find_library(LIB_zlib
             NAME  zlibstatic${CMAKE_STATIC_LIBRARY_SUFFIX}
             PATHS "${ZLIB_BIN_DIR}")
elseif(APPLE)
    find_library(LIB_zlib
             NAME  libz${CMAKE_STATIC_LIBRARY_SUFFIX}
             PATHS "${ZLIB_BIN_DIR}")
elseif(UNIX)
    find_library(LIB_zlib
             NAME  libz${CMAKE_STATIC_LIBRARY_SUFFIX}
             PATHS "${ZLIB_BIN_DIR}"
             NO_DEFAULT_PATH)
endif()

mark_as_advanced(LIB_zlib)

SET(ZLIB_LIBRARIES ${LIB_zlib})

ShipSources(SYSTEM_DIRECTORIES "${ZLIB_ROOT}"
            FILES "${ZLIB_ROOT}/zlib1211.zip")
