/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
///
/// @brief Declaration of a function to construct a path to a file that is
///        relative to the currently executing module.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __CREATEMODULERELATIVEPATH_H__
#define __CREATEMODULERELATIVEPATH_H__

#include <string>

namespace InternalUtils
{

    //////////////////////////////////////////////////////////////////////////
    //  Function: createmoduletelativepath
    //
    /// @brief Return a path to the specified filename that is relative to
    ///        the currently executing module.
    ///
    /// This function determines the location of the currently executing
    /// module and then constructs a path to the specified filename based on
    /// the module's path.  In other words, the specified filename is assumed
    /// to be in the same directory as the currently executing module.
    ///
    /// @note
    /// This function does not verify the existence of the file.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   None.
    ///
    /// @param[in] filename
    ///   The filename to add to the module's directory location.  This can
    ///   include path components; the filename is simply appended to the end
    ///   of the module's directory location.
    ///
    /// @return (std::string): A string containing the constructed path.
    //////////////////////////////////////////////////////////////////////////
    std::string createmodulerelativepath(
        const char* filename);

} // end InternalUtils namespace

#endif // __CREATEMODULERELATIVEPATH_H__
