/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
///
/// @brief Declaration of the direxists() function that determines whether a
///        directory exists.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __DIREXISTS_H__
#define __DIREXISTS_H__

namespace InternalUtils
{


    //////////////////////////////////////////////////////////////////////////
    //  Function: direxists
    //
    /// @brief Determine if a directory exists.
    ///
    /// This helper function asks the operating system if the specified
    /// directory exists.
    ///
    /// @par Assumptions:
    ///   The path is a path to a directory.
    ///
    /// @par Side Effects:
    ///   None.
    ///
    /// @param pDirname
    ///     Path to a directory to look for.
    ///
    /// @return (bool):
    ///     Returns true if the directory exists; otherwise, returns false
    ///     (the directory doesn't exist, the @a pDirname parameter is NULL,
    ///     or some other error occurred accessing the directory).
    //////////////////////////////////////////////////////////////////////////
    bool direxists(const char* pDirname);

} // end namespace InternalUtils

#endif // __DIREXISTS_H__
