/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
/// @brief Declaration of the getenvvar() function.
///
/// This utility function hides the platform-specific details of getting the
/// value of an environment variable.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __GETENVVAR_H__
#define __GETENVVAR_H__

namespace InternalUtils
{

    //////////////////////////////////////////////////////////////////////////
    //  Function: getenvvar
    //
    /// @brief retrieve the value of an environment variable.
    ///
    /// This helper function gets the value of a specified environment variable,
    /// returning the result as a string.  Returns an empty string if the
    /// environment variable does not exist.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   None.
    ///
    /// @param varName
    ///     The name of the environment variable to examine.
    ///
    /// @return (std::string):
    ///     Returns the value of the environment variable if found; otherwise,
    ///     returns an empty string.  Also returns an empty string if the
    ///     @a varName parameter is NULL.
    //////////////////////////////////////////////////////////////////////////
    std::string getenvvar(const char* varName);

} // end namespace InternalUtils

#endif // __GETENVVAR_H__
