/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
///
/// @brief Declaration of the geterrormessage() function that converts a
///        C++ standard library error code to a string.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __GETERRORMESSAGE_H__
#define __GETERRORMESSAGE_H__

#include <string>


namespace InternalUtils
{

    //////////////////////////////////////////////////////////////////////////
    //  Function: geterrormessage
    //
    /// @brief Returns a string containing the human-readable text for the
    ///        specified C++ standard library error code.
    ///
    /// This function is a wrapper to the strerror() C++ standard library
    /// function.
    ///
    /// @par Assumptions:
    ///   The error code is from the C++ standard library.
    ///
    /// @par Side Effects:
    ///   None.
    ///
    /// @param errcode
    ///   The error code to translate.
    ///
    /// @return (std::string): A string containing the error message.
    ///                        Returns an empty string of there is no
    ///                        corresponding error message.
    //////////////////////////////////////////////////////////////////////////
    std::string geterrormessage(int errcode);

} // end namespace InternalUtils

#endif // __GETERRORMESSAGE_H__
