/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
///
/// @brief Declaration of functions to access a logger object from a dynamic
///        library.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __GETLOGGER_H__
#define __GETLOGGER_H__

struct IIPCLogger; // forward reference, useable for pointers only.

namespace InternalUtils
{

    //////////////////////////////////////////////////////////////////////////
    //  Function: getlogger
    //
    /// @brief Retrieve an instance of a logger for the specified module and
    ///        file name.
    ///
    /// This helper function hides the details of getting a logger for a
    /// module and associated file name.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   A logger may be created and cached for the specified module and
    ///   log file name.
    ///
    /// @param[in] moduleName
    ///     The name of the module to be used in the log output.
    /// @param[in] logfilename
    ///     The name of the log file to which to log.
    ///
    /// @return (IIPCLogger*):
    ///   A IIPCLogger object representing the logger.  Returns NULL if the
    ///   logger could not be obtained.
    //////////////////////////////////////////////////////////////////////////
    IIPCLogger* getlogger(
        const char* moduleName,
        const char* logfilename);


    //////////////////////////////////////////////////////////////////////////
    //  Function: releaselogger
    //
    /// @brief Release a logger, freeing any resources associated with the
    ///        logger.
    ///
    /// This helper function takes steps to release all resources associated
    /// with the logger object.  Note that the logger object is reference-
    /// counted internally so only when the last reference to a particular
    /// logger is released, are the resources also released.
    ///
    /// @par Assumptions:
    ///   The logger was obtained with the getlogger() function.
    ///
    /// @par Side Effects:
    ///   The logger is released, which may trigger additional releases of
    ///   resources (such as closing the log file).
    ///
    /// @param[in] pLogger
    ///     The logger instance to release.  If NULL, the parameter is ignored
    ///     and nothing happens.
    ///
    /// @par Returns:
    ///   None.
    //////////////////////////////////////////////////////////////////////////
    void releaselogger(
        IIPCLogger* pLogger);

} // end namespace InternalUtils

#endif // __GETLOGGER_H__
