/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
///
/// @brief Declaration of the removefile() function that deletes a file.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __REMOVEFILE_H__
#define __REMOVEFILE_H__

namespace InternalUtils
{

    //////////////////////////////////////////////////////////////////////////
    //  Function: removefile
    //
    /// @brief Delete the specified file.
    ///
    /// This helper function removes the specified file from the disk.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   If the file exists and can be deleted, the file is deleted.
    ///
    /// @param pFilename
    ///     Path to the file to be deleted.
    ///
    /// @return (int):
    ///     Returns 0 if successful; otherwise, returns -1.  Consult errno for
    ///     details.
    //////////////////////////////////////////////////////////////////////////
    int removefile(const char* pFilename);

} // end namespace InternalUtils

#endif // __REMOVEFILE_H__
