/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
///
/// @brief Declarations of functions to replace strings or characters within a
///        source string, changing the source string in the process.
///
///////////////////////////////////////////////////////////////////////////////

#ifndef __REPLACE_H__
#define __REPLACE_H__

#include <string>

namespace InternalUtils
{
    //////////////////////////////////////////////////////////////////////////
    //  Function: replace
    //
    /// @brief Replace all occurrences of narrow string str1 with narrow string
    ///        str2 in narrow string s.
    ///
    /// If str1 is empty or either str1 or str2 are null, no replacement is
    /// made.  If str2 is empty then all matches to str1 are effectively
    /// removed from the string.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   The string 's' is modified by the replacement.
    ///
    /// @param s
    ///    String to search and modify.  If empty then do nothing and return
    ///    false.
    /// @param str1
    ///    Pointer to string to search for.  If NULL then do nothing and return
    ///    false.
    /// @param str2
    ///    Pointer to string to replace with (can be an empty string).  If
    ///    NULL then do nothing and return false.
    /// @param bCaseInsensitive
    ///    True if search is case insensitive; otherwise, false if search is
    ///    case sensitive (default is false)
    ///
    /// @return (bool):
    ///     Returns true if at least one replacement made; otherwise, returns
    ///     false if no replacements made.
    //////////////////////////////////////////////////////////////////////////
    bool replace(
        std::string& s,
        const char* str1,
        const char* str2,
        bool bCaseInsensitive = false);

    //////////////////////////////////////////////////////////////////////////
    //  Function: replace
    //
    /// @brief Replace all occurrences of wide string str1 with wide string
    ///        str2 in wide string s.
    ///
    /// If str1 is empty or either str1 or str2 are null, no replacement is
    /// made.  If str2 is empty then all matches to str1 are effectively
    /// removed from the string.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   The string 's' is modified by the replacement.
    ///
    /// @param s
    ///    String to search and modify.  If empty then do nothing and return
    ///    false.
    /// @param str1
    ///    Pointer to string to search for.  If NULL then do nothing and return
    ///    false.
    /// @param str2
    ///    Pointer to string to replace with (can be an empty string).  If
    ///    NULL then do nothing and return false.
    /// @param bCaseInsensitive
    ///    True if search is case insensitive; otherwise, false if search is
    ///    case sensitive (default is false)
    ///
    /// @return (bool):
    ///     Returns true if at least one replacement made; otherwise, returns
    ///     false if no replacements made.
    //////////////////////////////////////////////////////////////////////////
    bool replace(
        std::wstring& s,
        const wchar_t* str1,
        const wchar_t* str2,
        bool bCaseInsensitive = false);

    //////////////////////////////////////////////////////////////////////////
    //  Function: replace
    //
    /// @brief Replace all occurrences of narrow character c1 with narrow
    ///        character c2 in narrow string s.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   The string 's' is modified by the replacement.
    ///
    /// @param s
    ///    String to search and modify
    /// @param c1
    ///    Character to search for
    /// @param c2
    ///    Character to replace with
    /// @param bCaseInsensitive
    ///    True if search is case insensitive; otherwise, false if search is
    ///    case sensitive (default is false)
    ///
    /// @return (bool):
    ///     Returns true if at least one replacement made; otherwise, returns
    ///     false if no replacements made.
    //////////////////////////////////////////////////////////////////////////
    bool replace(
        std::string& s,
        char c1,
        char c2,
        bool bCaseInsensitive = false);

    //////////////////////////////////////////////////////////////////////////
    //  Function: replace
    //
    /// @brief Replace all occurrences of wide character c1 with wide character
    ///        c2 in wide string s.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   The string 's' is modified by the replacement.
    ///
    /// @param s
    ///    String to search and modify
    /// @param c1
    ///    Character to search for
    /// @param c2
    ///    Character to replace with
    /// @param bCaseInsensitive
    ///    True if search is case insensitive; otherwise, false if search is
    ///    case sensitive (default is false)
    ///
    /// @return (bool):
    ///     Returns true if at least one replacement made; otherwise, returns
    ///     false if no replacements made.
    //////////////////////////////////////////////////////////////////////////
    bool replace(
        std::wstring& s,
        wchar_t c1,
        wchar_t c2,
        bool bCaseInsensitive = false);

} // end namespace InternalUtils

#endif // __REPLACE_H__
