/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
/// @brief Declaration of the setenvvar() function.
///
/// This utility function hides the platform-specific details of setting the
/// value of an environment variable.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __SETENVVAR_H__
#define __SETENVVAR_H__

namespace InternalUtils
{

    //////////////////////////////////////////////////////////////////////////
    //  Function: setenvvar
    //
    /// @brief Add or change an environment variable with the specified value.
    ///
    /// This helper function sets the value of a specified environment variable.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   None.
    ///
    /// @param varName
    ///     The name of the environment variable to add/update.
    ///
    /// @param varValue
    ///     The value to set in the environment variable.  If this is NULL or
    ///     and empty string, the variable is removed.
    ///
    /// @returns (int):
    ///     0 if the environment variable was successfully set.  Otherwise,
    ///     returns an error code.
    //////////////////////////////////////////////////////////////////////////
    int setenvvar(const char* varName, const char* varValue);

} // end namespace InternalUtils

#endif // __SETENVVAR_H__
