/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
/// @brief Implementation of the skipendwhitespace() function.
///
/// This utility function hides the details of skipping trailing whitespace
/// in a given string.
///
//////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <string.h>
#include "skipendwhitespace.h"

namespace InternalUtils
{

    //////////////////////////////////////////////////////////////////////////
    // function skipendwhitespace
    //
    //////////////////////////////////////////////////////////////////////////
    const char* skipendwhitespace(const char* line, int lineLength)
    {
        const char* endOfLine = line;
        if (line != NULL)
        {
            if (lineLength == 0)
            {
                lineLength = static_cast<int>(strlen(line));
            }

            endOfLine = line + (lineLength - 1);
            while (endOfLine >= line && isspace(*endOfLine))
            {
                --endOfLine;
            }

            if (*endOfLine != '\0')
            {
                ++endOfLine;
            }
        }

        return endOfLine;
    }

} // end InternalUtils namespace
