/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
/// @brief Declaration of the skipendwhitespace() function.
///
/// This utility function hides the details of skipping trailing whitespace
/// in a given string.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __SKIPENDWHITESPACE_H__
#define __SKIPENDWHITESPACE_H__

namespace InternalUtils
{

    //////////////////////////////////////////////////////////////////////////////
    //  Function: skipendwhitespace
    //
    /// @brief Skips trailing white space in the given string by returning an
    ///        pointer to the last non-whitespace in the string.
    ///
    /// This function skips over trailing spaces, tabs, and newlines in the given
    /// string and returns a pointer to the last non-whitespace in the string.
    ///
    /// If the line is all whitespace, the returned pointer is one before the
    /// first character in the string.  This allows for uses such as this:
    /// @code
    /// const char* startOfLine = "name  ";
    /// const char* lastNonWhitespace = InternalUtils::skipendwhitespace(startOfLine, 0);
    /// std::string name(startOfLine, lastNonWhiteSpace - startOfLine);
    /// @endcode
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   None.
    ///
    /// @param[in] line
    ///   A pointer to the zero-terminated string to examine.
    ///
    /// @param[in] lineLength
    ///   The length of the line to examine.  If 0, assume @a line is zero-terminated
    ///   and use the end of @a line as the starting point.
    ///
    /// @return (const char*):
    ///   A pointer to one past the last non-whitespace character in the string.
    //////////////////////////////////////////////////////////////////////////////
    const char* skipendwhitespace(const char* line, int lineLength);

} // end InternalUtils namespace

#endif //__SKIPENDWHITESPACE_H__
