/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
/// @brief Declaration of the sleep() function.
///
/// This utility function hides the details of sleeping for a number of
/// milliseconds.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __INTERNALUTILS_SLEEP_H__
#define __INTERNALUTILS_SLEEP_H__

#if !defined(_MSC_VER) || _MSC_VER >= 1600
#include <stdint.h>
#endif

namespace InternalUtils
{
#if defined(_MSC_VER) && _MSC_VER < 1600
    // Visual Studio 2008 and earlier does not have stdint.h, so we need to
    // define the types ourselves.
    //
    // Define these inside InternalUtils namespace so they don't conflict
    // with other types similarly named.
    typedef unsigned __int32 uint32_t;
    typedef unsigned __int64 uint64_t;
#endif

    //////////////////////////////////////////////////////////////////////////////
    //  Function: sleep
    //
    /// @brief A platform-independent sleep to pause execution for a certain
    ///        number of milliseconds.
    ///
    /// This function puts the current thread to sleep for a period time that
    /// lasts for at least as long as the specified number of milliseconds.  Due
    /// to operating system and host resolution of timers, the delay could be a
    /// little longer than expected, especially for delays below 30 milliseconds.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   None.
    ///
    /// @param[out] msecs
    ///   The number of milliseconds to sleep.  If this is 0, the operating
    ///   system may take the opportunity to perform a thread switch for a brief
    ///   time.
    ///   
    /// @par Returns:
    ///   None.
    //////////////////////////////////////////////////////////////////////////////
    void sleep(uint32_t msecs);

} // end namespaec InternalUtils

#endif // __INTERNALUTILS_SLEEP_H__
