/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
/// @brief Declaration of the stringtolower() functions.
///
/// These utility functions provide platform-independent way to convert a
/// buffer or string object of characters to all lower-case.
///
//////////////////////////////////////////////////////////////////////////////

#ifndef __STRINGTOLOWER_H__
#define __STRINGTOLOWER_H__

namespace InternalUtils
{

    //////////////////////////////////////////////////////////////////////////
    //  Function: stringtolower
    //
    /// @brief Converts the specified number of characters in the given buffer
    ///        to lowercase.
    ///
    /// This helper function converts all letters in the specified buffer to
    /// lowercase using the current locale.  The process runs for the specified
    /// number of characters or until a zero terminator is reached, whichever
    /// is first.
    ///
    /// @par Assumptions:
    ///   The specified buffer contains text.
    ///
    /// @par Side Effects:
    ///   The specified buffer is modified to make all letters lowercase.
    ///
    /// @param buffer
    ///     A buffer of text to make lowercase.
    /// @param numChars
    ///     The number of characters to convert to lowercase.
    ///
    /// @par Returns:
    ///   None.
    //////////////////////////////////////////////////////////////////////////
    void stringtolower(
        char* buffer,
        int   numChars);

    //////////////////////////////////////////////////////////////////////////
    //  Function: stringtolower
    //
    /// @brief Converts the specified string to lowercase.
    ///
    /// This helper function converts all letters in the specified string to
    /// lowercase using the current locale.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   The specified string is modified to make all letters lowercase.
    ///
    /// @param buffer
    ///     The string to be modified.  The string is modified in place.
    ///
    /// @par Returns:
    ///   None.
    //////////////////////////////////////////////////////////////////////////
    void stringtolower(
        std::string& buffer);

} // end namespace InternalUtils

#endif // __STRINGTOLOWER_H__
