/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
///
/// @brief Declaration of the strstri() and wcsstri() functions.
///
/// These utility functions provide a platform-independent way of searching a
/// string for another string in a case-insensitive fashion.
///
///////////////////////////////////////////////////////////////////////////////

#ifndef __STRSTRI_H__
#define __STRSTRI_H__

namespace InternalUtils
{

    //////////////////////////////////////////////////////////////////////////
    //  Function: strstri
    //
    /// @brief Search for first occurrence of narrow string s2 in narrow string
    ///        s1 using a case-insensitive search.
    ///
    /// This function is similar to the C Library's strstr() function.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   None.
    ///
    /// @param s1
    ///     String to be searched.  If NULL then function returns NULL.
    /// @param s2
    ///     String to search for.  If NULL then function returns NULL.
    ///
    /// @par Returns:
    ///   Returns pointer into s1 to the first character of s2 if s2 was found.
    ///   Otherwise returns NULL indicating s2 was not found in s1.  If s1 or
    ///   s2 are NULL then returns NULL.
    //////////////////////////////////////////////////////////////////////////
    const char* strstri(
        const char* s1,
        const char* s2);


    //////////////////////////////////////////////////////////////////////////
    //  Function: wcsstri
    //
    /// @brief Search for first occurrence of wide string s2 in wide string
    ///        s1 using a case-insensitive search.
    ///
    /// This function is similar to the C Library's wcsstr() function.
    ///
    /// @par Assumptions:
    ///   None.
    ///
    /// @par Side Effects:
    ///   None.
    ///
    /// @param s1
    ///     String to be searched.  If NULL then function returns NULL.
    /// @param s2
    ///     String to search for.  If NULL then function returns NULL.
    ///
    /// @par Returns:
    ///   Returns pointer into s1 to the first character of s2 if s2 was found.
    ///   Otherwise returns NULL indicating s2 was not found in s1.  If s1 or
    ///   s2 are NULL then returns NULL.
    //////////////////////////////////////////////////////////////////////////
    const wchar_t* wcsstri(
        const wchar_t* s1,
        const wchar_t* s2);

} // end namespace InternalUtils

#endif // __STRSTRI_H__

