/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
///
/// @brief Implementation of the beginthread() function that runs a function
///        in another thread.
///
//////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <stdio.h>
#include "ui64tostring.h"
#include "sprintf_safe.h"

namespace InternalUtils
{
    //////////////////////////////////////////////////////////////////////////
    // Function: ui64todecimalstring
    //
    //////////////////////////////////////////////////////////////////////////
    std::string ui64todecimalstring(IU_UINT64 value, size_t width/* = 0*/)
    {
        char buffer[128] = { 0 };

#ifdef _MSC_VER
        sprintf_safe(buffer, sizeof(buffer), "% *I64u", width, value);
#else
        sprintf_safe(buffer, sizeof(buffer), "% *llu", width, value);
#endif
        return buffer;
    }
    
    //////////////////////////////////////////////////////////////////////////
    // Function: ui64tohexadecimalstring
    //
    //////////////////////////////////////////////////////////////////////////
    std::string ui64tohexadecimalstring(IU_UINT64 value, size_t width/* = 0*/, bool useUpperCase/* = false*/)
    {
        char buffer[128] = { 0 };

#ifdef _MSC_VER
        const char* formatString = useUpperCase ? "0x%0*I64X" : "0x%0*I64x";
        sprintf_safe(buffer, sizeof(buffer), formatString, width, value);
#else
        const char* formatString = useUpperCase ? "0x%0*llX" : "0x%0*llx";
        sprintf_safe(buffer, sizeof(buffer), formatString, width, value);
#endif
        return buffer;
    }

} // end namespace InternalUtils
