/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
/// @file
/// @internal
/// @brief Implementation of the vsprintf_safe() function.
///
/// This utility function is a "safe" version of the vsprintf() standard C
/// library funtion that prevents buffer overruns.
///
//////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <stdio.h>
#include <stdarg.h>
#include "vsprintf_safe.h"

namespace InternalUtils
{

    int vsprintf_safe(char* szBuffer, int nSize, const char* szFormatStr, va_list argptr )
    {
        int ret = 0;
        if (szBuffer != NULL && szFormatStr != NULL && nSize > 0)
        {
#ifdef _MSC_VER
            ret = vsnprintf_s(szBuffer, nSize, nSize - 1, szFormatStr, argptr);
#else
            ret = vsnprintf(szBuffer, nSize, szFormatStr, argptr);
            if (ret >= nSize)
            {
                ret = -1;
            }
#endif
            szBuffer[nSize - 1] = '\0';
        }
        return ret;
    }

} // end namespace InternalUtils
