#pragma once

#include <queue>
#include "Protocol.h"
#include <ProbeInstanceASD.h>
#include "Transport.hpp"
#include "RemoteConnection_Static.h"
#ifdef NEED_SAFE_CLIB
#include "safe_lib.h"
#endif
#include "ASDBaseProtocolDefs.h"

#if defined(HOST_LINUX) || defined(HOST_DARWIN)
#include <pthread.h>
#include <signal.h>
#else
#include <windows.h>
#include <synchapi.h>
#endif // DARWIN

// readPacket return codes
#define PacketRead_Complete 0
#define PacketRead_NotComplete 1
#define PacketRead_Error 2

//
//Abstract class ASD Base Protocol:
//This class handles ASD type headers for the ethernet messages but will not
//populate the payload. This way the payload can change if desired but the
//ethernet layer and agent control messages stay the same
//

class ASDBaseProtocol : public Protocol
{
public:
	ASDBaseProtocol();
	virtual Connection_Error ShiftJTAG(OpenIPC_DeviceId deviceId, JtagStateEncode state, char *writeBuffer, size_t writeSize, char* readBuffer, size_t readSize, GotoStateOptions *goto_state_opt);
	virtual Connection_Error ShiftI2C(OpenIPC_DeviceId deviceId, JtagStateEncode state, char *writeBuffer, size_t writeSize, char* readBuffer, size_t readSize, GotoStateOptions *goto_state_opt);
	virtual Connection_Error Flush(Connection_Error readResult = No_Error);
	virtual bool DataFlushed(void);
	virtual void ReceiveData(void);
	virtual Connection_Error ProcessError(message read_message);
	virtual Connection_Error StartDataTransfer(unsigned int messageType, JtagChainParameters *params = NULL);
	virtual Connection_Error EndDataTransfer(JtagChainParameters *params = NULL);
	virtual Connection_Error ConnectionEstablished();
	virtual Connection_Error SetHardwareLogLevel(LoggingConfiguration log_config) = 0;
	virtual Connection_Error SetHardwareGpioConfig(const uint8_t gpio_config) = 0;
	virtual Connection_Error SetHardwareJTAGDriverMode(JtagChainParameters params) = 0;
	virtual ~ASDBaseProtocol();
	ASDBaseProtocol(const ASDBaseProtocol&) = delete; // copy constructor
	ASDBaseProtocol& operator=(const ASDBaseProtocol&) = delete; // copy-assignment operator

protected:
	virtual Connection_Error DecryptData(struct message *message) = 0;
	virtual Connection_Error EncryptData(struct message *message) = 0;
	virtual Connection_Error ProcessReadBuffers(struct message*, std::shared_ptr<std::list<std::shared_ptr<OutputBuffers>>> tmp_input_list) = 0;
	virtual Connection_Error ProcessReadBuffersI2c(struct message*, std::shared_ptr<std::list<std::shared_ptr<OutputBuffers>>> tmp_input_list) = 0;
	virtual Connection_Error doubleShiftCheck(JtagStateEncode state) = 0;
	virtual Connection_Error ShiftJTAGProtocol(OpenIPC_DeviceId deviceId, JtagStateEncode state, char *writeBuffer, size_t writeSize, char* readBuffer, size_t readSize, GotoStateOptions *goto_state_opt) = 0;
	virtual Connection_Error ShiftI2cProtocol(OpenIPC_DeviceId deviceId, char *writeBuffer, size_t writeSize, char* readBuffer, size_t readSize, GotoStateOptions *goto_state_opt) = 0;
	virtual Connection_Error SetHWStateToTheOutMsg(JtagChainParameters *_params) = 0;
	virtual Connection_Error ClearPRDYTimeout(void) = 0;
	virtual void InitializeData(void);
	virtual void connect(void);
	virtual void InitLocals(void);
	virtual unsigned int readPacket(void);
	virtual Connection_Error SendData(bool flush, Connection_Error readResult);
	void WakeReadEvent();
	Connection_Error CheckReadAlive();
	Connection_Error WaitForReadEvent();
	Connection_Error ObtainBMCNumInFlightMsgs();
	Connection_Error ObtainBmcMessageSize();
	Connection_Error ObtainSupportedJtagChains();
	Connection_Error ObtainSupportedI2cBuses();
	Connection_Error ObtainDownstreamVersion();
	Connection_Error SetClientTimeout();
	Connection_Error setMsgType(unsigned int msgType);
	Connection_Error validMsgType(unsigned int msgType);
	void setMsgSize();
	Connection_Error InitClient();
	Connection_Error CreateReadMonitorThread();
	Connection_Error ConnectSetup(void);

	std::shared_ptr<ProbeInstanceASD> probeInstance;
	Connection_Error connectionEstablished;
	bool connect_setup;
	unsigned int msgType;
	unsigned int cmd_stat;
	struct message write_message;
	uint16_t write_message_offset;
	struct message read_message;
	std::queue<struct payload_descritpor> payload_desc_queue;
	bool clear_prdy_timeout;
	Connection_Error readResult;
	char *send_buffer;
	int tag;
	bool encryptionEnabled;
	std::shared_ptr<Transport> UseTransport;
	std::shared_ptr<std::list<std::shared_ptr<OutputBuffers>>> out_buffers_list;
	unsigned int Timeout;
	unsigned read_used;   // Bytes read into read_message
	unsigned int maxNumBuffers;
	unsigned int supportedJtagChains;
	unsigned int supportedI2cBusesCount;
	I2cConfiguration supportedI2cBusAddresses[I2C_MAX_BUSES];
	unsigned int payloadSize;

#if defined(HOST_LINUX) || defined(HOST_DARWIN)
	int mutex_lock(pthread_mutex_t *mutex);
	int mutex_unlock(pthread_mutex_t *mutex);
	pthread_mutex_t *list_mutex, list_mutex_m;
#else
	BOOL mutex_lock(HANDLE mutex);
	BOOL mutex_unlock(HANDLE mutex);
	HANDLE list_mutex;
#endif //HOST_DARWIN

#if defined(HOST_LINUX) || defined(HOST_DARWIN)
	static void *ReadMonitorThread(void *lpParam);
	pthread_t readMonitorThread;
	pthread_mutex_t mutex;
	pthread_cond_t  condition;
#else
	static DWORD WINAPI ReadMonitorThread(LPVOID lpParam);
	HANDLE readMonitorThread;
	CONDITION_VARIABLE readEvent;
	CRITICAL_SECTION   readCriticalSection;
#endif // DARWIN

};
