#pragma once
#include <list>
#include <memory>
#define STATE_CHANGE_BYTE 0x20
#define CMD_WAITCYCLES 0x10
#define WRITE_SCAN 0x40
#define READ_SCAN 0x80
#define RW_SCAN 0xC0
#define MAX_RW_SCAN_SIZE 8
#define TARGET_RESET_ASSERT 0x1
#define TARGET_RESET_DEASSERT 0x2
#define TARGET_PRDY_EVENT 0x3
#define TARGET_POWER_ASSERT 0x4
#define TARGET_POWER_DEASSERT 0x5
#define WAITPRDY_TIMEOUT_EVENT 0x6
#define MBP_EVENT 0x7
#define DEFAULT_NUMBER_BUFFERS 20
#define DEFAULT_SUPPORTED_JTAG_CHAINS 1
#define DEFAULT_PAYLOAD_SIZE 3000
#define BROADCAST_MESSAGE_ORIGIN_ID 0x7
#define INVALID_TAG_NUMBER 256
#define WRITE_PINS 0x7
#define SCAN_CHAIN_SELECT 0x40
#define MAX_SCAN_CHAINS 0xf
#define WAIT_PRDY 0x12
#define CLEAR_WAITPRDY_TIMEOUT 0x13
#define WAIT_SYNC 0x19

#define AGENT_CONFIG_TYPE_LOGGING 1
#define AGENT_CONFIG_TYPE_GPIO 2
#define AGENT_CONFIG_TYPE_JTAG_DRIVER_MODE 3

#define BITS_IN_VECTOR_BYTE 8
#define MAX_BIT_VECTOR_BYTES 16 // support up to 128 chains

enum AGENT_CONTROL_CODES
{
	QUERY_SUPPORTED_MESSAGE_TYPES = 0,
	INIT_SECURE_CHANNEL = 1,
	TERMINATE_SECURE_CHANNEL = 2,
	QUERY_NUM_IN_FLIGHT_MSGS = 3,
	OBTAIN_DOWNSTREAM_VERSION = 5,
	HARDWARE_CONFIGURATION = 8,
	SOCKET_TIMEOUT = 9,
	QUERY_MAX_MESSAGE_SIZE = 13,
	QUERY_SUPPORTED_JTAG_CHAINS = 14,
	QUERY_SUPPORTED_I2C_BUSES = 15
};

#pragma pack(push,1)
struct message_header {
	unsigned int origin_id : 3;
	unsigned int reserved : 1;
	unsigned int enc_bit : 1;
	unsigned int type : 3;
	unsigned int size_lsb : 8;
	unsigned int size_msb : 5;
	unsigned int tag : 3;
	unsigned int cmd_stat : 8;
};
#pragma pack(pop)

struct message {
	struct message_header header;
	char *buffer;
	char auth_code[16];
	uint16_t max_payload;
	uint16_t buffer_size;
};

struct payload_descritpor {
	unsigned int tag;
	std::shared_ptr<std::list<std::shared_ptr<OutputBuffers>>> out_buffers;
};