#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2016-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
///  @file
///
///  @brief Contains methods for obtaining instances of the Probe interfaces
///
///  For additional information on obtaining and using instances, see @ref probeusage.
///
//////////////////////////////////////////////////////////////////////////////
#include <string>
#include <list>
#include <ProbeTypes.h>
#include <TapStateMachineEncode.h>
#include <CProbePlugin.hpp>
#include <algorithm>
#include <queue>
#include <string.h>

#include "GotoStateOptions.h"
#include "OutputBuffers.h"

#include "ProbeInstanceASD.h"
#include "JtagChainInfo.h"
#include "JtagChainParameters.h"
#include "ConnectionError.h"
#include "ConnectionParameters.h"

class Transport;
class Protocol;


#if defined(HOST_LINUX) || defined(HOST_DARWIN)
#define EXTERN_PREFIX extern
#define EXPORT_PREFIX __attribute__ ((visibility("default")))
#else
#define EXTERN_PREFIX
#define EXPORT_PREFIX __declspec(dllexport)
#endif // DARWIN

class Connection
{
public:
	virtual Connection_Error Shift(OpenIPC_DeviceId deviceId, JtagStateEncode state, char *writeBuffer, size_t writeSize, char* readBuffer, size_t readSize, GotoStateOptions *goto_state_opt = NULL);
	virtual Connection_Error StartDataTransfer(OpenIPC_DeviceId deviceId, unsigned int messageType, JtagChainParameters *params = NULL);
	virtual Connection_Error EndDataTransfer(OpenIPC_DeviceId deviceId, JtagChainParameters *params = NULL);
	virtual Connection_Error UpdateInterfacePaddingSettings(InterfacePadding *interfacePaddingSettings);
	Connection_Error RegisterProbeInstance(std::shared_ptr<ProbeInstanceASD> probeInstance);
	bool ProbeRegistered();
	bool InitSuccess();
	Connection_Error GetConnectionError();
	EXPORT_PREFIX void ReceiveData();
	void SetProbeDeviceId(OpenIPC_DeviceId deviceId);
	bool SetRCDeviceId(OpenIPC_DeviceId deviceId);
	Connection(std::shared_ptr<ProbeInstanceASD> probe);
	Connection(const Connection& other) = delete;
	Connection& operator= (Connection&& other) = delete;
	Connection();
	virtual ~Connection();
	void EnableEncryption(bool enable);
	static std::string GenerateKey(std::string &ipaddress, std::string &port);

	Connection_Error SetHardwareLogLevel(LoggingConfiguration log_config);
	Connection_Error SetHardwareGpioConfig(const uint8_t gpio_config);
	Connection_Error SetHardwareJTAGDriverMode(JtagChainParameters params);
	std::shared_ptr<Transport> UseTransport;
	std::string Key;
protected:
	std::shared_ptr<Protocol> protocol;
	OpenIPC_DeviceId currentUser;

	std::shared_ptr<ProbeInstanceASD> probeInstance;
	OpenIPC_DeviceId associatedRCPlugin;
	bool encryptionEnabled;
	std::shared_ptr<ConnectionParameters> connectionParameters;
	bool connect_setup;
	unsigned int msgType;
	Connection_Error connectionEstablished;
	OpenIPC_DeviceId probeDeviceId;
	Connection_Error ShiftJTAG(OpenIPC_DeviceId deviceId, JtagStateEncode state, char *writeBuffer, size_t writeSize, char* readBuffer, size_t readSize, GotoStateOptions *goto_state_opt = NULL);
	Connection_Error ShiftI2C(OpenIPC_DeviceId deviceId, JtagStateEncode state, char *writeBuffer, size_t writeSize, char* readBuffer, size_t readSize, GotoStateOptions *goto_state_opt = NULL);
	Connection_Error ShiftPM(OpenIPC_DeviceId deviceId, char *writeBuffer, size_t writeSize, char *readBuffer, size_t readSize);
	Connection_Error setMsgType(unsigned int msgType);
	Connection_Error validMsgType(unsigned int msgType);
	virtual Connection_Error InitializeProtocol();
	virtual Connection_Error InitializeTransport();
private:
	void init();
};
