#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2016-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
///  @file
///
///  @brief Contains methods for obtaining instances of the Probe interfaces
///
///  For additional information on obtaining and using instances, see @ref probeusage.
///
//////////////////////////////////////////////////////////////////////////////
enum Connection_Error {
	No_Error = 0,
	Bad_Argument = 1,
	Invalid_Device_Id = 2,
	Invalid_Data_Size = 3,
	Socket_Failed_Send = 4,
	Socket_Failed_Recv = 5,
	Socket_Send_Recv_Wrong_Tag = 6, // Unused
	Socket_Received_Error_From_Tap = 7,
	Error_Processing_Received_Data = 8,
	Error_Receiveing_Thread_Died = 9,
	Connection_Busy = 10,
	User_Not_Registered = 11,
	User_Already_Registered = 12,
	Failed_To_Register = 13,
	Failed_To_UnRegister = 14,
	Probe_Plugin_Not_Registered = 15,
	Error_Connection_Taken = 16,
	RC_Plugin_Not_Registered = 17, // Unused
	Invalid_Message_Type = 18,
	Wrong_Socket_Data_Size = 19, // Unused
	Data_Not_Flushed = 20,
	Could_Not_Handle_Mutex = 21,
	Could_Not_Contact_BMC = 22,
	Could_Not_Connect_To_BMC = 23,
	Connection_To_BMC_Rejected = 24,
	Socket_Read_Wait_Failure = 25,
	Read_Thread_Init_Failure = 26,
	Mutex_Error = 27,
	Null_Pointer = 28,
	Initialize_Error = 29,
	I2C_Response_Error = 30,
	I2C_Request_Error = 31,
	I2C_Nack_Received = 32,
	I2C_Write_Acks_Not_Received =33,
	I2C_Unknown_Request = 34,
	I2C_Unknown_Response = 35,
	Multi_Bundle_Error = 36,
	ASD_MSG_CRYPY_NOT_SUPPORTED = 37,
	ASD_FAILURE_INIT_JTAG_HANDLER = 38,
	ASD_FAILURE_INIT_I2C_HANDLER = 39,
	ASD_FAILURE_DEINIT_JTAG_HANDLER = 40,
	ASD_MSG_NOT_SUPPORTED = 41,
	ASD_FAILURE_PROCESS_JTAG_MSG = 42,
	ASD_FAILURE_PROCESS_I2C_MSG = 43,
	ASD_FAILURE_PROCESS_I2C_LOCK = 44,
	ASD_I2C_MSG_NOT_SUPPORTED = 45,
	ASD_FAILURE_REMOVE_I2C_LOCK = 46,
	ASD_FAILURE_HEADER_SIZE = 47,
	ASD_FAILURE_XDP_PRESENT = 48,
	ASD_UNKNOWN_ERROR = 0x7F,
	Not_Implemented = 0xFFFF,
	WAIT_PRDY_Timeout = 0x160014 //this is OpenIPC_Error_Interface_Jtag_Boundary_Scan_Timeout in OpenIPC world
};
#define CONNECTION_PASS(error) ((error) == Connection_Error::No_Error)
