#pragma once
#include <string>
#include "SSLMethod.hpp"
#include <memory>
#include<vector>
#define I2C_MAX_BUSES 20

enum SocketType {
	BASIC_SOCKET = 0,
	SSL_SOCKET = 1,
};

typedef struct TransportParameters {
	std::string ipAddress;
	std::string ipPort;
	std::string targetChainFile;
	std::string chainFileVerification;
	std::string passphrase;
	SocketType socketType;
	std::vector<std::string> fileNames;
} TransportParameters;

typedef struct ProtocolParameters {
	unsigned int payloadSize;
	unsigned int maxNumBuffers;
	unsigned int supportedJtagChains;
	unsigned int supportedI2cBusesCount;
	I2cConfiguration supportedI2cBusAddresses[I2C_MAX_BUSES];
	unsigned int timeout;
} ProtocolParameters;

typedef struct ConnectionParameters {
	std::shared_ptr<TransportParameters> transportParameters;
	std::shared_ptr<ProtocolParameters> protocolParameters;
	bool connectionInitialized;
} ConnectionParameters;