#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2016-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
///  @file
///
///  @brief Contains methods for obtaining instances of the Probe interfaces
///
///  For additional information on obtaining and using instances, see @ref probeusage.
///
//////////////////////////////////////////////////////////////////////////////
#include "RemoteConnection_Static.h"
#include "JtagChainParameters.h"
#include "ConnectionParameters.h"
#include "GotoStateOptions.h"

class ProbeInstanceASD;

#if defined(HOST_LINUX) || defined(HOST_DARWIN)
#define EXTERN_PREFIX extern
#define EXPORT_PREFIX __attribute__ ((visibility("default")))
#else
#define EXTERN_PREFIX
#define EXPORT_PREFIX __declspec(dllexport)
#endif
#ifndef RC_PLUGIN
EXPORT_PREFIX EXTERN_PREFIX Connection_Error RegisterProbePlugin(std::shared_ptr<ProbeInstanceASD> probe);
#endif
EXPORT_PREFIX EXTERN_PREFIX Connection_Error UnRegisterPlugin(OpenIPC_DeviceId deviceId);
EXPORT_PREFIX EXTERN_PREFIX Connection_Error RegisterRCPlugin(OpenIPC_DeviceId deviceId, std::string &address, std::string &port);
EXPORT_PREFIX EXTERN_PREFIX Connection_Error StartDataTransfer(OpenIPC_DeviceId deviceId, unsigned int messageType, JtagChainParameters *params = NULL);
EXPORT_PREFIX EXTERN_PREFIX Connection_Error EndDataTransfer(OpenIPC_DeviceId deviceId, JtagChainParameters *params = NULL);
EXPORT_PREFIX EXTERN_PREFIX Connection_Error UpdateInterfacePaddingSettings(OpenIPC_DeviceId deviceId, InterfacePadding *interfacePaddingSettings);
EXPORT_PREFIX EXTERN_PREFIX Connection_Error RemoteShift(OpenIPC_DeviceId deviceId, JtagStateEncodeASD state, char *writeBuffer, size_t writeSize, char* readBuffer, size_t readSize, GotoStateOptions *goto_state_opt = NULL);
EXPORT_PREFIX EXTERN_PREFIX Connection_Error EnableEncryption(OpenIPC_DeviceId deviceId, bool enable);
EXPORT_PREFIX EXTERN_PREFIX Connection_Error RegisterLogHandler(PluginLogCallbackHandler handler);
EXPORT_PREFIX EXTERN_PREFIX Connection_Error RegisterStreamLogHandler(PluginStreamLogCallbackHandler handler);
EXPORT_PREFIX EXTERN_PREFIX Connection_Error ChangeStreamLogLevel(PPI_Stream stream, PPI_NotificationLevel level);
EXPORT_PREFIX EXTERN_PREFIX Connection_Error RegisterNotificationHandler(PluginNotificationCallbackHandler handler);
EXPORT_PREFIX EXTERN_PREFIX Connection_Error ChangeNotificationLevel(PPI_NotificationLevel level);
EXPORT_PREFIX EXTERN_PREFIX Connection_Error ChangeHardwareLogLevel(LoggingConfiguration log_config);
EXPORT_PREFIX EXTERN_PREFIX Connection_Error SetHardwareGpioConfig(OpenIPC_DeviceId deviceId, const uint8_t gpio_config);
EXPORT_PREFIX EXTERN_PREFIX Connection_Error SetHardwareJTAGDriverMode(OpenIPC_DeviceId deviceId, JtagChainParameters params);
