#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2016-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
#include "ConnectionError.h"
#include <Foundation/Error/ErrorTypes.h>
#include <Foundation/Types.h>
#include <memory>
class Connection;

#define AGENT_CONTROL_MESSAGE_TYPE 0x0
#define JTAG_MESSAGE_TYPE 0x01
#define PM_MESSAGE_TYPE 0x02
#define DMA_MESSAGE_TYPE 0x03
#define HARDWARE_LOG_EVENT 0x05
#define I2C_MESSAGE_TYPE 0x06
#define DMA_MESSAGE_TYPE_READ 0x0E
#define DMA_MESSAGE_TYPE_WRITE 0x0F
#define MAX_DATA_PAYLOAD 4106 //4096 of data plus 10 bytes for address and length
#define MAX_PACKET_PAYLOAD MAX_DATA_PAYLOAD + 4 //4 bytes for the header

enum JtagStateEncodeASD
{
	JtagTLRASD = 0x00,
	JtagRTIASD = 0x01,
	JtagSelDRASD = 0x02,
	JtagCapDRASD = 0x03,
	JtagShfDRASD = 0x04,
	JtagEx1DRASD = 0x05,
	JtagPauDRASD = 0x06,
	JtagEx2DRASD = 0x07,
	JtagUpdDRASD = 0x08,
	JtagSelIRASD = 0x09,
	JtagCapIRASD = 0x0A,
	JtagShfIRASD = 0x0B,
	JtagEx1IRASD = 0x0C,
	JtagPauIRASD = 0x0D,
	JtagEx2IRASD = 0x0E,
	JtagUpdIRASD = 0x0F,
	JtagNoStateChange = 0x10
};

OpenIPC_Error RegisterConnection(std::shared_ptr<Connection> connection);
OpenIPC_Error RegisterProbeConnection(OpenIPC_DeviceId deviceId, std::shared_ptr<Connection> connection);

