#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
#include <string>
#include <functional>

#if defined(HOST_LINUX) || defined(HOST_DARWIN)
typedef int SOCKET;
#else
#include <WinSock2.h>
#endif // DARWIN

enum SSL_Error {
	SSL_No_Error = 0,
	Unable_to_Contact_Target,
	Handshake_Failed,
	Passphrase_File_Not_Found,
	General_Failure = 127,
	General_Warning = 128,   // 8th bit set, otherwise 0
	Unable_To_Verify_Target,
	Verify_Target_Off,
	Chain_File_Not_Found
};

struct SSL_Config {
	std::string chainFileOption;
};

#define SSL_PASS(error) ((error & General_Failure) == SSL_Error::SSL_No_Error)

// Assume TLS 1.2
// Dependency injection interface
class SSLMethod
{
public:
	virtual bool Open(std::string &address, std::string &port, std::string &targetChainFile) = 0;
	virtual int Close() = 0;
	virtual void RegisterErrorHandler(std::function<void(SSL_Error error, std::string message)> errorHandlerFunction) = 0;
	virtual int Write(char *buffer, int length) = 0;
	virtual int Read(char *buffer, int size) = 0;
	virtual int Getfd() = 0;
	virtual int Pending() = 0;
	virtual void SetConfig(SSL_Config config) = 0;
	virtual SSL_Config GetConfig() = 0;

protected:
	virtual ~SSLMethod() {};
};
