#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
#include "TransportSocket.hpp"
#include "TransportTLS.hpp"
//#include <fileops.h> // todo:
#include <cstring>

#define MAX_BG_PASSPHRASE_LEN 127
#define BG_PASSPHRASE_LEN_MASK 0x7f
#define CLIENT_AUTHENTICATION_VERSION '0'

// From Intel BMC Project
// Header/Handshake responses
typedef enum {
	AUTH_HANDSHAKE_SUCCESS = 0x30,
	AUTH_HANDSHAKE_SYSERR = 0x24, // system error.
	AUTH_HANDSHAKE_BUSY = 0x2b,   // session already in progress
	AUTH_HANDSHAKE_FAILURE = 0x3f,
} auth_handshake_ret_t;

// From Intel BMC Project
// Structure returned to client with auth result
typedef struct {
	unsigned char svr_hdr_version; // Header version
	auth_handshake_ret_t result_code;
} auth_handshake_resp_t;

// Connect to JTAG Socket Server using TLS and then send BMC ASDBG passphrase before starting ASD Protocol
class TransportTLSPassPhrase : public TransportTLS
{
public:
	TransportTLSPassPhrase(const char* address, const char* sslPort,
		const char* targetChainFile, std::shared_ptr<SSLMethod> sslMethod,
		std::string &passphrase, std::shared_ptr<OSDependencies> deps);
	void SetPassphrase(char * passphrase);
	Connection_Error Connect() override;

protected:
	char ASDBG_PassPhrase[MAX_BG_PASSPHRASE_LEN + 1]; // Password plus byte 0 Client Authentication Version
	uint8_t PassPhraseLength;
};
