//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include <iostream>
#include <vector>

#include "ProbePluginASD_JTAG.hpp"

#ifdef USE_INTERFACE_SCAN
#include "MetaEncoding.h"
#include "I2cEncoding.h"
#include <deque>
#else
#include <cstdint>
#include <cstdlib>
#include <cstddef>
#include <limits>
#include <type_traits>
#include <stdexcept>
#endif // USE_INTERFACE_SCAN
#include <memory>

#include <Foundation/Types.h>
#include <Foundation/Error/ErrorTypes.h>
#include <Foundation/BitData/BitData.h>
#include "ProbePluginErrors.h"
#ifdef USE_INTERFACE_SCAN
#include "PinsEncoding.h"
#endif

#include "Public/StructuredData.h"					// For XML support
#include <stringcopy.h>
#include "BundleOperations.h"
#include "BundleHelpersASD.h"
#include "JTAGRegisterBasedOperations.h"
#include "JtagStateBasedOperations.h"
#include "JTAGPinsBasedOperations.h"
#include "LoopOperations.h"
#include "SlotOperations.h"
#include "PinOperations.h"
#include "I2cCommandOperations.h"
#include "I2CDirectOperations.h"
#include "RemoteConnection.h"

#include "PPI_InterfaceTriggerResponse.h"
#include "InterfaceInstanceRemotePins.h"
#include "ProbeInstanceASD.h"

#include <algorithm>
#include <cmath>

#ifdef USE_INTERFACE_SCAN
inline PinTypeEncode LookupInterfaceScanPin(PPI_Pins_TypeEncode pin, bool& isValid)
{
	isValid = true;
	switch (pin)
	{
	case PPI_PINS_hook0:
		return Pin_Hook0;
	case PPI_PINS_hook1:
		return Pin_Hook1;
	case PPI_PINS_hook2:
		return Pin_Hook2;
	case PPI_PINS_hook3:
		return Pin_Hook3;
	case PPI_PINS_hook4:
		return Pin_Hook4;
	case PPI_PINS_hook5:
		return Pin_Hook5;
	case PPI_PINS_hook6:
		return Pin_Hook6;
	case PPI_PINS_hook7:
		return Pin_Hook7;
	case PPI_PINS_hook8:
		return Pin_Hook7;
	case PPI_PINS_hook9:
		return Pin_Hook7;
	case PPI_PINS_Pod_Prsnt1_N:
		isValid = false;
		return Pin_DBR;
	case PPI_PINS_Pod_Prsnt2_N:
		isValid = false;
		return Pin_DBR;
	case PPI_PINS_Preq_N:
		return Pin_PREQ;
	case PPI_PINS_Prdy_N:
		return Pin_PRDY;
	case PPI_PINS_TRST:
		return Pin_TRSTn;
	case PPI_PINS_TMS_bit:
	case PPI_PINS_TDI_bit:
	case PPI_PINS_TDO_bit:
	case PPI_PINS_TCK_bit:
		isValid = false;
		return Pin_TRSTn;
	case PPI_PINS_PowerButton:
		return Pin_Hook1;
	case PPI_PINS_ResetButton:
		return Pin_Hook7;
	case PPI_PINS_SystemTapPowerGood:
		return Pin_PWRGOOD;
	case PPI_PINS_SystemReset:
	case PPI_PINS_CoreReset:
		return Pin_ResetOccurred;
	case PPI_PINS_TapReady:
	case PPI_PINS_CorePowerGood:
		return Pin_PWRGOOD;
	case PPI_PINS_PowerBreak1:
		return Pin_Hook3;
	case PPI_PINS_PowerBreak2:
		return Pin_Hook2;
	case PPI_PINS_PowerBreak3:
		return Pin_Hook2;
	case PPI_PINS_JtagDisable:
	case PPI_PINS_I2CDisable:
		isValid = false;
		return Pin_Hook0;
	case PPI_PINS_SystemPowerGood:
		return Pin_PWRGOOD;
	case PPI_PINS_SystemBootStall:
		return Pin_Hook3;
	case PPI_PINS_obsA_func0:
		return Pin_obsA_func0;
	case PPI_PINS_obsA_func1:
		return Pin_obsA_func1;
	case PPI_PINS_obsB_func0:
		return Pin_obsB_func0;
	case PPI_PINS_obsB_func1:
		return Pin_obsB_func1;
	case PPI_PINS_obsC_func0:
		return Pin_obsC_func0;
	case PPI_PINS_obsC_func1:
		return Pin_obsC_func1;
	case PPI_PINS_obsD_func0:
		return Pin_obsD_func0;
	case PPI_PINS_obsD_func1:
		return Pin_obsD_func1;
	case PPI_PINS_obsA_data0:
		return Pin_obsA_data0;
	case PPI_PINS_obsA_data1:
		return Pin_obsA_data1;
	case PPI_PINS_obsA_data2:
		return Pin_obsA_data2;
	case PPI_PINS_obsA_data3:
		return Pin_obsA_data3;
	case PPI_PINS_obsB_data0:
		return Pin_obsB_data0;
	case PPI_PINS_obsB_data1:
		return Pin_obsB_data1;
	case PPI_PINS_obsB_data2:
		return Pin_obsB_data2;
	case PPI_PINS_obsB_data3:
		return Pin_obsB_data3;
	case PPI_PINS_obsC_data0:
		return Pin_obsC_data0;
	case PPI_PINS_obsC_data1:
		return Pin_obsC_data1;
	case PPI_PINS_obsC_data2:
		return Pin_obsC_data2;
	case PPI_PINS_obsC_data3:
		return Pin_obsC_data3;
	case PPI_PINS_obsD_data0:
		return Pin_obsD_data0;
	case PPI_PINS_obsD_data1:
		return Pin_obsD_data1;
	case PPI_PINS_obsD_data2:
		return Pin_obsD_data2;
	case PPI_PINS_obsD_data3:
		return Pin_obsD_data3;
	case PPI_PINS_NO_ACTION:
		isValid = false;
		return Pin_Hook0;
	default:
		isValid = false;
		return Pin_Hook0;
	}
}

inline PPI_Pins_TypeEncode LookupPPIPin(PinTypeEncode pin, bool& isValid)
{
	isValid = true;
	switch (pin)
	{
	case Pin_Hook0:
		return PPI_PINS_hook0;
	case Pin_Hook1:
		return PPI_PINS_hook1;
	case Pin_Hook2:
		return PPI_PINS_hook2;
	case Pin_Hook3:
		return PPI_PINS_hook3;
	case Pin_Hook4:
		return PPI_PINS_hook4;
	case Pin_Hook5:
		return PPI_PINS_hook5;
	case Pin_Hook6:
		return PPI_PINS_hook6;
	case Pin_Hook7:
		return PPI_PINS_hook7;
	case Pin_ResetOccurred:
		return PPI_PINS_SystemReset;
	case Pin_DBR:
		return PPI_PINS_Pod_Prsnt1_N; // I think
	case Pin_PREQ:
		return PPI_PINS_Preq_N;
	case Pin_PRDY:
		return PPI_PINS_Prdy_N;
	case Pin_PWRGOOD:
		return PPI_PINS_SystemPowerGood;
	case Pin_TRSTn:
		return PPI_PINS_TRST;
	case Pin_obsA_func0:
		return PPI_PINS_obsA_func0;
	case Pin_obsA_func1:
		return PPI_PINS_obsA_func1;
	case Pin_obsB_func0:
		return PPI_PINS_obsB_func0;
	case Pin_obsB_func1:
		return PPI_PINS_obsB_func1;
	case Pin_obsC_func0:
		return PPI_PINS_obsC_func0;
	case Pin_obsC_func1:
		return PPI_PINS_obsC_func1;
	case Pin_obsD_func0:
		return PPI_PINS_obsD_func0;
	case Pin_obsD_func1:
		return PPI_PINS_obsD_func1;
	case Pin_obsA_data0:
		return PPI_PINS_obsA_data0;
	case Pin_obsA_data1:
		return PPI_PINS_obsA_data1;
	case Pin_obsA_data2:
		return PPI_PINS_obsA_data2;
	case Pin_obsA_data3:
		return PPI_PINS_obsA_data3;
	case Pin_obsB_data0:
		return PPI_PINS_obsB_data0;
	case Pin_obsB_data1:
		return PPI_PINS_obsB_data1;
	case Pin_obsB_data2:
		return PPI_PINS_obsB_data2;
	case Pin_obsB_data3:
		return PPI_PINS_obsB_data3;
	case Pin_obsC_data0:
		return PPI_PINS_obsC_data0;
	case Pin_obsC_data1:
		return PPI_PINS_obsC_data1;
	case Pin_obsC_data2:
		return PPI_PINS_obsC_data2;
	case Pin_obsC_data3:
		return PPI_PINS_obsC_data3;
	case Pin_obsD_data0:
		return PPI_PINS_obsD_data0;
	case Pin_obsD_data1:
		return PPI_PINS_obsD_data1;
	case Pin_obsD_data2:
		return PPI_PINS_obsD_data2;
	case Pin_obsD_data3:
		return PPI_PINS_obsD_data3;
	default:
		isValid = false;
		return PPI_PINS_hook0;
	}
}
#endif//USE_INTERFACE_SCAN

extern const char* _probename;

// Bundle functions:

PROBEPLUGIN_API PPI_SlotHandle PPI_Slot_Allocate( PPI_ProbeBundleHandle handle, uint64_t bitSize){
	Local_Handle* current = (Local_Handle*) handle;
	BitData* bd = BitData_CreateManaged(bitSize);
	current->slots.push_back(bd);
	return (PPI_SlotHandle*)(current->slots.size());
}

PROBEPLUGIN_API OpenIPC_Error PPI_Slot_Free(PPI_SlotHandle* handle){
	*handle = NULL;
	return OpenIPC_Error_No_Error;
}



/********** JTAG ***********/

#ifdef USE_INTERFACE_SCAN
typedef struct WritebackRecord
{
	uint32_t            start;
	uint32_t			sizeInBits;
	bool                isIR;
} WritebackRecord;
#endif

PROBEPLUGIN_API OpenIPC_Error PPI_JTAG_IRRegisterShift(
	PPI_ProbeBundleHandle handle,
	uint32_t shiftLengthBits,
	const uint8_t* const inBits,
	uint8_t* outBits,
	const PPI_JTAG_RegisterOptions* const options
	){
		return OpenIPC_Error_Not_Supported; // Not implemented yet
}

PROBEPLUGIN_API OpenIPC_Error PPI_JTAG_DRRegisterShift(
	PPI_ProbeBundleHandle handle,
	uint32_t shiftLengthBits,
	const uint8_t* const inBits,
	uint8_t* outBits,
	const PPI_JTAG_RegisterOptions* const options
	){
		return OpenIPC_Error_Not_Supported; // Not implemented yet
}

PROBEPLUGIN_API OpenIPC_Error PPI_JTAG_SetParameters(OpenIPC_DeviceId jtagInterface,
													 uint64_t numberOfClocksInTlr,
													 PPI_JTAG_RESET_OPTIONS_ET mechanismToEnterTLR,
													 PPI_JTAG_ParametersOptions* options
													 ){
														 return OpenIPC_Error_Not_Supported; // Not implemented yet
}

PROBEPLUGIN_API OpenIPC_Error PPI_JTAG_GetParameters(OpenIPC_DeviceId jtagInterface,
													 uint64_t* numberOfClocksInTlr,
													 PPI_JTAG_RESET_OPTIONS_ET* mechanismToEnterTLR,
													 PPI_JTAG_ParametersOptions* options
													 ){
														return OpenIPC_Error_Not_Supported; // Not implemented yet
}

PROBEPLUGIN_API OpenIPC_Error PPI_JTAG_EnterTLR(
	PPI_ProbeBundleHandle handle){
		return OpenIPC_Error_Not_Supported; // Not implemented yet
}

PROBEPLUGIN_API OpenIPC_Error PPI_JTAG_Delay(
	PPI_ProbeBundleHandle handle,
	uint32_t numberOfClocks,
	PPI_JTAG_DelayOptions* options
	){
		return OpenIPC_Error_Not_Supported; // Not implemented yet
}

PROBEPLUGIN_API OpenIPC_Error PPI_Loop_CaptureAll(PPI_ProbeBundleHandle handle,
												  PPI_ProbeBundleHandle body,
												  uint32_t numberOfIterations,
												  uint32_t bufferLengthInBytes,
												  uint8_t* bufferForIterations,
												  uint32_t* currentBit,
												  const PPI_Loop_Options* const options
												  )
{
	return OpenIPC_Error_Not_Supported; // Not implemented yet
}


PROBEPLUGIN_API OpenIPC_Error PPI_Loop_LoopBreakOnComparisonSuccess(PPI_ProbeBundleHandle handle,
																	PPI_ProbeBundleHandle body,
																	uint32_t maxNumberOfIterations,
																	const PPI_Loop_LoopWithBreakOptions* const options
																	){
																		return OpenIPC_Error_Not_Supported; // Not implemented yet
}

OpenIPC_Error PPI_Pins_Delay(PPI_ProbeBundleHandle handle,
			 uint32_t timeInMicroSeconds,
			 const PPI_Pins_DelayOptions* const options){
		PinsDelayCommand *cmd = new PinsDelayCommand();
		cmd->timeInMicroSeconds = timeInMicroSeconds;
		cmd->plugin = GetProbePluginInstanceASD();
		return handle_command(cmd, handle);
}

PROBEPLUGIN_API OpenIPC_Error PPI_I2C_CommandRead(
	PPI_ProbeBundleHandle handle,
	uint8_t deviceId,
	const uint8_t* const commandBuffer,
	uint32_t commandBufferLength,
	uint8_t* dataBuffer,
	uint32_t dataBufferLength,
	const PPI_I2C_Options* const options){
		return OpenIPC_Error_Not_Supported; // Not implemented yet
}

PROBEPLUGIN_API OpenIPC_Error PPI_I2C_CommandWrite(
												   PPI_ProbeBundleHandle handle,
	uint8_t deviceId,
	const uint8_t* const commandBuffer,
	uint32_t commandBufferLength,
	const uint8_t* const dataBuffer,
	uint32_t dataBufferLength,
	const PPI_I2C_Options* const options){
		return OpenIPC_Error_Not_Supported; // Not implemented yet
}
