#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2016-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
///  @file
///
///  @brief Contains methods for obtaining instances of the Probe interfaces
///
///  For additional information on obtaining and using instances, see @ref probeusage.
///
//////////////////////////////////////////////////////////////////////////////

#if !defined(__BUNDLEHELPER_H__)
#define __BUNDLEHELPER_H__

#include "Foundation/Types.h"			// for standard IDL types
#include <Foundation/Error/OpenIPC_ErrorContext.h>			// for IDL_Error type
#include <vector>

#include "BundleOperations.h"
#include "JTAGRegisterBasedOperations.h"
#include "JtagStateBasedOperations.h"
#include "JTAGPinsBasedOperations.h"
#include "LoopOperations.h"

#include "CProbePlugin.hpp"
#include <Foundation/BitData/BitData.h>

#include "ProbePluginASD_JTAG.hpp"

#include "Command.h"
#include "Handle.h"
#include "Connection.h"

class Command;

extern ProbePluginASD_JTAG* GetProbePluginInstanceASD();

typedef struct {
	uint8_t* buffer;
	uint32_t buffer_length;
	uint32_t dword_position;
	uint32_t length_in_bits;
} JTAG_Writeback;

uint64_t* getNumberOfClocksInTlR();

PPI_JTAG_RESET_OPTIONS_ET* getResetMethod();

OpenIPC_Error ExecuteHandle(Local_Handle* current,  OpenIPC_DeviceId deviceInterface, bool keepLock);
OpenIPC_Error To_OpenIPC_Error(Connection_Error error);
std::string Connection_Error_text(Connection_Error);

class StartCommand : public Command{
public:
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	virtual uint32_t length_of_output();
};

class AssertPinCommand : public Command {
public:
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	PPI_Pins_TypeEncode pin;
	PPI_PINS_OPTIONS_ET options;
	uint8_t savedSlot;
	virtual uint32_t length_of_output();
	ProbePluginASD_JTAG* plugin;
};

class DeassertPinCommand : public Command {
public:
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	PPI_Pins_TypeEncode pin;
	PPI_PINS_OPTIONS_ET options;
	uint8_t savedSlot;
	virtual uint32_t length_of_output();
	ProbePluginASD_JTAG* plugin;
};

class PinsDelayCommand : public Command {
public:
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	uint32_t timeInMicroSeconds;
	virtual uint32_t length_of_output();
	ProbePluginASD_JTAG* plugin;
};

class SetPinCommand : public Command {
public:
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	PPI_Pins_TypeEncode pin;
	PPI_bool pinValue;
	PPI_PINS_OPTIONS_ET options;
	uint8_t savedSlot;
	virtual uint32_t length_of_output();
	ProbePluginASD_JTAG* plugin;
};

class ReadPinCommand : public Command {
public:
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	PPI_Pins_TypeEncode pin;
	uint32_t *pinValue;
	PPI_PINS_OPTIONS_ET options;
	uint8_t savedSlot;
	virtual uint32_t length_of_output();
	ProbePluginASD_JTAG* plugin;
};

class LoopBreakCommand : public Command {
public:
	Local_Handle* body;
	uint32_t maxNumberOfIterations;
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	virtual uint32_t length_of_output();
};

class LoopCaptureAllCommand : public Command {
protected:
	OpenIPC_Error Copy(uint32_t& current_position);
	uint32_t numberOfBitsInBuffer;

public:
	Local_Handle* body;
	uint32_t numberOfIterations;
	uint32_t bufferLengthInBytes;
	uint8_t* bufferForIterations;
	uint32_t* currentBit;
	BitData bdForBuffer;
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	virtual uint32_t length_of_output();
};

class SlotModificationCommand : public Command{
public:
	uint32_t savedSlot;
	uint8_t numberOfBits;
	std::vector<uint8_t> mask;
	std::vector<uint8_t> valueToOrIn;

	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	virtual uint32_t length_of_output();
};

class SlotCountCommand : public Command{
public:
	uint32_t* numberOfSlots;

	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	virtual uint32_t length_of_output();
};

class SlotInfoCommand : public Command{
public:
	uint8_t savedSlot;
	uint32_t* lengthOfDataInSlot;

	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	virtual uint32_t length_of_output();
};

class SlotComparisonCommand : public Command{
public:
	uint8_t savedSlot;
	uint8_t numberOfBits;
	std::vector<uint8_t> mask;
	std::vector<uint8_t> match;
	bool* comparisonResult;

	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	virtual uint32_t length_of_output();
};


class GotoStateJTAGCommandASD : public Command{
public:
	JtagStateEncode goto_state;
	uint32_t number_of_clocks_in_state;
	ProbePluginASD_JTAG* plugin;
	const PPI_JTAG_StateGotoOptions* options;
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	virtual uint32_t length_of_output();
	~GotoStateJTAGCommandASD();
};

class IRShiftJTAGCommandASD : public Command {
public:
	uint32_t shiftLengthBits;
	std::vector<uint8_t> inBits;
	uint8_t* outBits;
	PPI_JTAG_TDI_TDO_OPTIONS_ET TdiTdoOptions;
	uint8_t savedSlot;
	ProbePluginASD_JTAG* plugin;
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	virtual uint32_t length_of_output();
};

class DRShiftJTAGCommandASD : public Command {
public:
	uint32_t shiftLengthBits;
	std::vector<uint8_t> inBits;
	uint8_t* outBits;
	PPI_JTAG_TDI_TDO_OPTIONS_ET TdiTdoOptions;
	uint8_t savedSlot;
	ProbePluginASD_JTAG* plugin;
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	virtual uint32_t length_of_output();
};

class JTAGDelay : public Command {
public:
	uint32_t numberOfClocks;
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	virtual uint32_t length_of_output();
};

class JTAGUpdateBundlePadding : public Command {
public:
	int32_t irPaddingNearTDI;
	int32_t irPaddingNearTDO;
	int32_t drPaddingNearTDI;
	int32_t drPaddingNearTDO;
	PPI_bool drValueConstantOne;
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	virtual uint32_t length_of_output();
	ProbePluginASD_JTAG* plugin;
};

class I2cWriteCfgCommandASD : public Command {
public:
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	virtual uint32_t length_of_output();
	ProbePluginASD_JTAG* plugin;
};

class I2cReadCommandASD : public Command {
public:
	uint8_t deviceId;
	uint32_t bufferLength;
	uint8_t* readBuffer;
	PPI_bool forceStop;
	PPI_bool* addressAck;
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	virtual uint32_t length_of_output();
	ProbePluginASD_JTAG* plugin;
};

class I2cWriteCommandASD : public Command {
public:
	uint8_t deviceId;
	uint32_t bufferLength;
	const uint8_t* writeBuffer;
	PPI_bool forceStop;
	PPI_bool* addressAck;
	uint32_t* lastDataAck;
	uint32_t clockSpeed;
	virtual OpenIPC_Error LocalExecute(Local_Handle* handle, OpenIPC_DeviceId deviceInterface, bool doneExecuting);
	virtual uint32_t length_of_output();
	ProbePluginASD_JTAG* plugin;
};


#endif
