#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2016-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////

#include "JtagStateBasedOperations.h"
#include "JtagChainParameters.h"

typedef struct GotoStateOptions {
	uint32_t number_of_clocks_in_state;
	const PPI_JTAG_StateGotoOptions* options;
	I2cReadParams readParams;
	I2cWriteParams writeParams;
	bool isI2cRead;
	bool flush;
	GotoStateOptions()
		: number_of_clocks_in_state(0), options(nullptr),
		readParams {0,0, nullptr, false, nullptr},
		writeParams {0,0, nullptr,false, nullptr, nullptr},
		isI2cRead(false), flush(false)

	{
	}
} GotoStateOptions;
