//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
#include "InterfaceInstanceJtagASD.hpp"
#include "GotoStateOptions.h"
#include "RemoteConnection_Static.h"
#include "RemoteConnection.h"
#include "ProbePluginErrors.h"
#include "BundleHelpersASD.h"

#include <cstring>

// TBD: add JTAG config knobs to the settings map
InterfaceInstanceJtagASD::InterfaceInstanceJtagASD(uint32_t interface_refid, uint32_t instance_id, PPI_InterfaceJTAGCapabilities caps, JtagChainInfo jtagSettingsIn) :
	InterfaceInstance(interface_refid, PPI_interfaceTypeJtag, instance_id),
	jtagActive(false), lastjtagstate(JtagStateEncode::JtagTLR), capabilities(caps),
	_eventHandlerFunction(nullptr), irPaddingNearTDI(0), irPaddingNearTDO(0),
	drPaddingNearTDI(0), drPaddingNearTDO(0), drValueConstantOne(0), jtagSettings(jtagSettingsIn)
{
	settings.Set("Jtag.LeadingTCKs", "10");
	settings.Set("Jtag.TrailingTCKs", "10");
	settings.Set(JtagEncryptionProtocol, "0");
	SettingsUpdated();
}

void InterfaceInstanceJtagASD::SettingsUpdated()
{
	// Only check the settings we expect to change
	for (auto iter = settings.keyBegin(); iter != settings.keyEnd(); ++iter)
	{
		if(!std::strcmp(iter->get()->c_str(), JtagEncryptionProtocol.c_str())) {
			SetEncryptionProtocol(settings.GetUint32(JtagEncryptionProtocol));
		}
	}
}

OpenIPC_Error InterfaceInstanceJtagASD::GotoState(JtagStateEncode state, uint32_t count, const PPI_JTAG_StateGotoOptions* options)
{
	GotoStateOptions goto_state_opt = GotoStateOptions();
	goto_state_opt.number_of_clocks_in_state = count;
	goto_state_opt.options = options;
	return To_OpenIPC_Error(RemoteShift(probe->deviceID, (JtagStateEncodeASD)state, NULL, 0, NULL, 0, &goto_state_opt));
}

//////////////////////////////////////////////////////////////////////////////
// InterfaceRegisterEventHandler
//////////////////////////////////////////////////////////////////////////////
OpenIPC_Error InterfaceInstanceJtagASD::InterfaceRegisterEventHandler(
	PluginEventCallbackHandler eventHandlerFunction
)
{
	OpenIPC_Error openIPCError = OpenIPC_Error_No_Error;

	if (eventHandlerFunction == nullptr)
		return openIPCError;

	if (_eventHandlerFunction == nullptr)
	{
		_eventHandlerFunction = eventHandlerFunction;
	}
	else
	{
		openIPCError = OpenIPC_Error_Callback_Already_Initialized;
		PPI_ERROR(OpenIPC_INVALID_DEVICE_ID, openIPCError);
	}

	return openIPCError;
}


OpenIPC_Error InterfaceInstanceJtagASD::Shift(JtagStateEncode state, char *writeBuffer, size_t writeSize, char* readBuffer, size_t readSize)
{
	return To_OpenIPC_Error(RemoteShift(probe->deviceID, (JtagStateEncodeASD)state, writeBuffer, writeSize, readBuffer, readSize));
}

OpenIPC_Error InterfaceInstanceJtagASD::GetInterfacePadding(uint32_t* irPaddingNearTDI,
	uint32_t* irPaddingNearTDO,
	uint32_t* drPaddingNearTDI,
	uint32_t* drPaddingNearTDO,
	PPI_bool* drValueConstantOne)
{
	OpenIPC_Error openIPCError = OpenIPC_Error_No_Error;

	if (irPaddingNearTDI == nullptr ||
		irPaddingNearTDO == nullptr ||
		drPaddingNearTDI == nullptr ||
		drPaddingNearTDO == nullptr ||
		drValueConstantOne == nullptr)
	{
		openIPCError = OpenIPC_Error_Null_Pointer;
	}
	else {
		*irPaddingNearTDI = this->irPaddingNearTDI;
		*irPaddingNearTDO = this->irPaddingNearTDO;
		*drPaddingNearTDI = this->drPaddingNearTDI;
		*drPaddingNearTDO = this->drPaddingNearTDO;
		*drValueConstantOne = this->drValueConstantOne;
	}
	return openIPCError;
}

OpenIPC_Error InterfaceInstanceJtagASD::SetInterfacePadding(uint32_t irPaddingNearTDI,
	uint32_t irPaddingNearTDO,
	uint32_t drPaddingNearTDI,
	uint32_t drPaddingNearTDO,
	PPI_bool drValueConstantOne)
{
	this->irPaddingNearTDI = irPaddingNearTDI;
	this->irPaddingNearTDO = irPaddingNearTDO;
	this->drPaddingNearTDI = drPaddingNearTDI;
	this->drPaddingNearTDO = drPaddingNearTDO;
	this->drValueConstantOne = drValueConstantOne;
	return OpenIPC_Error_No_Error;
}

void InterfaceInstanceJtagASD::SetEncryptionProtocol(uint32_t value)
{
	_encryptionProtocol = value;
}

ASD_JTAG_PROTOCOL InterfaceInstanceJtagASD::EncryptionProtocol(void)
{
	return (ASD_JTAG_PROTOCOL)_encryptionProtocol;
}

void InterfaceInstanceJtagASD::ObtainJtagChainParameters(JtagChainParameters *params)
{
	if (params != NULL) {
		if (params->InterfacePaddingSettings != NULL) {
			params->InterfacePaddingSettings->drPaddingNearTDI = drPaddingNearTDI;
			params->InterfacePaddingSettings->drPaddingNearTDO = drPaddingNearTDO;
			params->InterfacePaddingSettings->irPaddingNearTDI = irPaddingNearTDI;
			params->InterfacePaddingSettings->irPaddingNearTDO = irPaddingNearTDO;
		}
		if (params->JtagChainSettings != NULL) {
			*params->JtagChainSettings = jtagSettings;
		}
	}
}

void InterfaceInstanceJtagASD::SetMultiBundleExecute(bool flag)
{
	jtagSettings.MultiBundleExecute = flag;
}

void InterfaceInstanceJtagASD::SetMultiBundleFinalInterface(bool flag)
{
	jtagSettings.MultiBundleFinalInterface = flag;
}

void InterfaceInstanceJtagASD::SetSendWaitSync(bool flag)
{
	jtagSettings.SendWaitSync = flag;
}
