#pragma once
//////////////////////////////////////////////////////////////////////////////
//
//                      INTEL CONFIDENTIAL
//       Copyright 2016-2017 Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its
// suppliers. Title to the Material remains with Intel Corporation, its
// suppliers, or licensors. The Material contains trade secrets and
// proprietary and confidential information of Intel Corporation, its
// suppliers, and licensors, and is protected by worldwide copyright and trade
// secret laws and treaty provisions. No part of the Material may be used,
// copied, reproduced, modified, published, uploaded, posted, transmitted,
// distributed, or disclosed in any way without Intel's prior express written
// permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or
// delivery of the Materials, either expressly, by implication, inducement,
// estoppel or otherwise. Any license under such intellectual property rights
// must be express and approved by Intel in writing.
//
// Unless otherwise agreed by Intel in writing, you may not remove or alter
// this notice or any other notice embedded in Materials by Intel or Intel's
// suppliers or licensors in any way.
//
//////////////////////////////////////////////////////////////////////////////
#include "CProbePlugin.hpp"

#define READ_CMD_BIT 0x8
#define CFGREG_PIN_STATUS 0x1

#if defined(HOST_LINUX) || defined(HOST_DARWIN)
;
#endif
class  InterfaceInstanceRemotePins : public InterfaceInstancePins
{
public:
	static const int READ = 0;
	static const int WRITE = 1;
	static const int READWRITE = 2;
	InterfaceInstanceRemotePins(uint32_t interface_refid, uint32_t instance_id, PPI_InterfacePinsCapabilities caps);
	virtual OpenIPC_Error AddPin(PPI_Pins_TypeEncode openIPCValue, uint32_t protocolValue, uint32_t readWrite);
	OpenIPC_Error GetDrivablePins(std::vector<PPI_Pins_TypeEncode>& pins) const;
	OpenIPC_Error GetReadablePins(std::vector<PPI_Pins_TypeEncode>& pins) const;
	virtual void AddTriggerResponse(std::shared_ptr<PPI_InterfaceTriggerResponse>);
	virtual ~InterfaceInstanceRemotePins() {};
	virtual void SettingsUpdated() override;
	virtual OpenIPC_Error DrivePin(uint8_t state, PPI_Pins_TypeEncode pin);
	virtual OpenIPC_Error ReadPin(PPI_Pins_TypeEncode pin, uint32_t *pinValue);
protected:
	std::vector<PPI_Pins_TypeEncode> readPins;
	std::vector<PPI_Pins_TypeEncode> drivePins;
	std::map<PPI_Pins_TypeEncode, uint32_t> openIPC2Protocol;
};
