
set(Public_Include_Headers "../../Public_Include/Foundation/BitData/BitData.h"
                           "../../Public_Include/Foundation/BitData/BitDataTypes.h"
                           "../../Public_Include/Foundation/BitData/OpenIPC_BitData.h")
set(HeaderFiles_Headers "stdafx.h")

set(PrebuildScript_Others "createdefifnewer.py")

ADD_PRECOMPILED_HEADER("stdafx.h" "stdafx.cpp" SourceFiles_Sources)

FILE(GLOB CMakeIncludes CMakeIncludes//*.cmake)

source_group("CMake Includes" FILES ${CMakeIncludes})
source_group("Public_Include" FILES ${Public_Include_Headers})
source_group("Header Files" FILES ${HeaderFiles_Headers})
source_group("Source Files" FILES ${SourceFiles_Sources})

set(SOURCES ${SOURCES} ${Public_Include_Headers} ${HeaderFiles_Headers} ${SourceFiles_Sources} ${CMakeIncludes})

ShipSources(FILES ${SOURCES} ${PrebuildScript_Others} CMakeLists.txt)

if(WIN32)
    configure_file(
      ${MAIN_ROOT}/${INCLUDE_DIR}/resource_template.rc
      ${CMAKE_CURRENT_BINARY_DIR}/Generated/resource.rc
      @ONLY)

    set(ResourceFiles "./Generated/resource.rc")
    source_group("Resource Files" FILES ${ResourceFiles} )

    set(PrebuildScript_Output "${CMAKE_CURRENT_BINARY_DIR}/BitData.def")

    source_group("Prebuild Script" FILES ${PrebuildScript_Others} )

    set(SOURCES ${SOURCES} ${ResourceFiles} ${PrebuildScript_Others} ${PrebuildScript_Output})
endif()
