
set(HeaderFiles_Headers "Public/Async.h"
                        "Public/DeepMap.h"
                        "Public/DeviceDataCache.h"
                        "Public/CaseInsensitiveMap.h"
                        "Public/ExceptionBridge.h"
                        "Public/FormatTime.h"
                        "Public/Frequency.h"
                        "Public/HardwareBreakpointProtect.h"
                        "Public/LeakDetection.h"
                        "Public/ManipulatePath.h"
                        "Public/MemoryOperations.h"
                        "Public/MemoryCopy.h"
                        "Public/ModuleAccess.h"
                        "Public/Name.h"
                        "Public/PollingThreadPool.h"
                        "Public/PopNewOverride.h"
                        "Public/PushNewOverride.h"
                        "Public/ExecutionEnvironment.h"
                        "Public/SafeString.h"
                        "Public/TimeScaleBase.h"
                        "${OPENIPC_ROOT}/Source/Public_Include/Foundation/Panic/Panic.h" # hack: there is no real owner of Panic.h so we include it here
                        "stdafx.h")

set(SourceFiles_Sources "CaseInsensitiveMap.cpp"
                        "ExecutionEnvironment.cpp"
                        "FormatTime.cpp"
                        "Frequency.cpp"
                        "HardwareBreakpointProtect.cpp"
                        "ManipulatePath.cpp"
                        "MemoryOperations.cpp"
                        "MemoryCopy.cpp"
                        "ModuleAccess.cpp"
                        "Name.cpp"
                        "PollingThreadPool.cpp"
                        "SafeString.cpp")

ADD_PRECOMPILED_HEADER("stdafx.h" "stdafx.cpp" SourceFiles_Sources)

FILE(GLOB CMakeIncludes CMakeIncludes//*.cmake)

source_group("CMake Includes" FILES ${CMakeIncludes})
source_group("Header Files" FILES ${HeaderFiles_Headers})
source_group("Source Files" FILES ${SourceFiles_Sources})

set(SOURCES ${SOURCES} ${HeaderFiles_Headers} ${SourceFiles_Sources} ${CMakeIncludes} NatvisFile.natvis)

ShipSources(FILES ${SOURCES} CMakeLists.txt)
