/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

#include "stdafx.h"

#include "ManipulatePath.h"
#include "ExecutionEnvironment.h"

boost::filesystem::path CommonUtils::MakePathRelative(boost::filesystem::path base, boost::filesystem::path full)
{
    base = boost::filesystem::absolute(base);
    full = boost::filesystem::absolute(full);

    boost::filesystem::path ret;
    boost::filesystem::path::const_iterator itrFrom(base.begin());
    boost::filesystem::path::const_iterator itrTo(full.begin());

    // Find common base
    for (boost::filesystem::path::const_iterator toEnd(full.end()), fromEnd(base.end()) ; itrFrom != fromEnd && itrTo != toEnd && *itrFrom == *itrTo; ++itrFrom, ++itrTo);

    // Navigate backwards in directory to reach previously found base
    for (boost::filesystem::path::const_iterator fromEnd(base.end()); itrFrom != fromEnd; ++itrFrom)
    {
        if ((*itrFrom) != ".")
        {
            ret /= "..";
        }
    }

    // Now navigate down the directory branch
    boost::filesystem::path::const_iterator begin = itrTo;
    boost::filesystem::path::const_iterator end = full.end();

    for( ; begin != end ; ++begin )
    {
        ret /= *begin;
    }

    return ret;
}


OpenIPC_Error CommonUtils::SanitizePath(boost::filesystem::path& path)
{
    OpenIPC_Error error = OpenIPC_Error_No_Error;
#if defined(HOST_LINUX) || defined(HOST_DARWIN)
    if ((!path.empty()) && (path.string()[0] == '~'))
    {
        std::string homeDir;
        error = GetUserHomeDirectory(homeDir);
        if (OpenIPC_PASS(error))
        {
            path = boost::filesystem::path(homeDir) / path.string().substr(1, std::string::npos);
        }
    }
#else
    (void)path;
#endif
    return error;
}
