/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
#include "Name.h"

#include <memory>
#include <mutex>
#include <unordered_map>
#include <vector>

using namespace CommonUtils;

namespace
{

static std::mutex _nameIndexLookUpMutex;
static std::unordered_map<std::string, Name::Index> _nameStringToIndex;
static std::vector<std::string> _nameIndexToString;

}

const Name Name::Unnamed("<unnamed>");

Name::Name() :
    _index(Index(-1))
{
}

Name::Name(const char* name) :
    _index(_LookUpIndex(name))
{
}

Name::Name(const std::string& name) :
    _index(_LookUpIndex(name))
{
}

const std::string& Name::AsString() const
{
    static const std::string emptyString = "";
    if (IsEmpty())
    {
        return emptyString;
    }
    else
    {
        if (_index < _nameIndexToString.size())
        {
            return _nameIndexToString[_index];
        }
        else
        {
            return emptyString;
        }
    }
}

const char* Name::GetData() const
{
    return AsString().data();
}

Name::Index Name::GetIndex() const
{
    return _index;
}

bool Name::IsEmpty() const
{
    return _index == Index(-1);
}

bool Name::operator<(Name name) const
{
    return _index < name._index;
}

bool Name::operator==(Name name) const
{
    return _index == name._index;
}

bool Name::operator!=(Name name) const
{
    return _index != name._index;
}

Name::Index Name::_LookUpIndex(const std::string& string)
{
    std::lock_guard<std::mutex> lock(_nameIndexLookUpMutex);

    Name::Index index = Name::Index(-1);

    if (string.empty())
    {
        return index;
    }

    // If this is the first encounter of this name
    auto it = _nameStringToIndex.find(string);
    if (it == _nameStringToIndex.end())
    {
        // If this is the first name added to the index then reserve space
        if (_nameIndexToString.size() == 0)
        {
            _nameIndexToString.reserve(1024);
        }

        // Add the string to the string look-up table
        index = static_cast<Name::Index>(_nameIndexToString.size());
        _nameIndexToString.push_back(string);

        // Add the index to the index look-up table
        _nameStringToIndex[string] = index;
    }
    else
    {
        index = it->second;
    }

    return index;
}

namespace std
{

std::size_t hash<CommonUtils::Name>::operator()(const CommonUtils::Name& name) const
{
    return static_cast<std::size_t>(name.GetIndex());
}

}
