/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

#pragma once

#include <map>

// DeepMap is a representation of a map of maps of maps....
template<typename, typename, typename, class ...> class DeepMap; // Class that can take 3 or more type arguments

template<typename T1, typename T2, typename T3> // Specialization for 3 argument case
class DeepMap<T1, T2, T3>
{
    std::map<T1, std::map<T2, T3>> _map;
public:
    auto& operator[](const T1& key)
    {
        return _map[key];
    }

    auto& AsMap() const noexcept { return _map; }
    auto& AsMap() noexcept { return _map; }
    auto begin() const noexcept { return _map.begin(); }
    auto end() const noexcept { return _map.end(); }
};

template<typename T1, typename T2, typename T3, typename T4, typename ... Args> // specialization for 4 or more argument case
class DeepMap<T1, T2, T3, T4, Args ...>
{
    std::map<T1, DeepMap<T2, T3, T4, Args ...>> _map;
public:
    auto& operator[](const T1& key)
    {
        return _map[key];
    }

    auto& AsMap() const noexcept { return _map; }
    auto& AsMap() noexcept { return _map; }
    auto begin() const noexcept { return _map.begin(); }
    auto end() const noexcept { return _map.end(); }
};
