/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
///  @file
///
///  @brief This file implements functions used for loading DLLs and finding
///         the functions they expose.
//////////////////////////////////////////////////////////////////////////////

#pragma once

#include <Components/Common/CommonErrors.h>
#include <Foundation/Error/Error.h>

#include <string>

typedef void * MODULE_ACCESS_HANDLE;

///
/// @brief Contains the methods of the Common subsystem.
namespace CommonUtils
{
    ///
    /// @brief Finds the path of the currently running module.
    ///
    /// @param[out] path
    ///     The path of the current module.
    ///
    /// @return (OpenIPC_Error): A code indicating success or failure.
    /// @retval OpenIPC_Error_No_Error
    ///     Indicates success.
	OpenIPC_Error GetCurrentModulePath(
		OUT std::string&			path);

    ///
    /// @brief Loads a DLL and verifies its signature.
    ///
    /// @param[in] path
    ///     The full path to the DLL being loaded.
    /// @param[out]  moduleHandle
    ///     Pointer to a handle to recieve the DLL.
    ///
    /// @return (OpenIPC_Error): A code indicating success or failure.
    /// @retval OpenIPC_Error_No_Error
    ///     Indicates success.
    /// @retval OpenIPC_Error_Null_Pointer
    ///     The @a moduleHandle parameter is NULL.
    OpenIPC_Error LoadModule(
        IN  const std::string&		path,
        OUT MODULE_ACCESS_HANDLE*	moduleHandle);
	
    ///
    /// @brief Unloads the module referenced by the handle
    ///
    /// @param[in]  moduleHandle
    ///     Handle to free.
    ///
    /// @return (OpenIPC_Error): A code indicating success or failure.
    /// @retval OpenIPC_Error_No_Error
    ///     Indicates success.
    OpenIPC_Error UnloadModule(
        IN  MODULE_ACCESS_HANDLE	moduleHandle);

    ///
    /// @brief Gets a function pointer for a function referenced by name and module handle.
    ///
    /// @param[out] functionPointer
    ///     The function pointer in the module.
    ///
    /// @param[in]  moduleHandle
    ///     Handle to the module that contains the function.
    ///
    /// @param[in]  functionName
    ///     Name of the function to find
	///
    /// @return (OpenIPC_Error): A code indicating success or failure.
    /// @retval OpenIPC_Error_No_Error
    ///     Indicates success.
    /// @retval OpenIPC_Error_Internal_Error
    ///     An error occurred.
	OpenIPC_Error GetFunctionFromModule(void** functionPointer,
        IN  MODULE_ACCESS_HANDLE	moduleHandle,
        IN  const std::string&		functionName);
}