/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
#include "stdafx.h"

#include "SafeString.h"
#include "InternalUtils/stringcopy.h"

#include <cstdio>
#include <cstdarg>

namespace CommonUtils
{

    int SafeStringCopy(char* destinationBuffer, size_t destinationBufferSize, const char* sourceBuffer)
    {
        return InternalUtils::stringcopy(destinationBuffer, destinationBufferSize, sourceBuffer);
    }

    int SafeStringCopy(char* destinationBuffer, size_t destinationBufferSize, const std::string& sourceBuffer)
    {
        return InternalUtils::stringcopy(destinationBuffer, destinationBufferSize, sourceBuffer.c_str());
    }

    int SafeStringFormat(char* destinationBuffer, size_t destinationBufferSize, const char* format, ...)
    {
        if (!destinationBuffer || !format)
        {
            return -1;
        }
        if (destinationBufferSize == 0)
        {
            return 0;
        }

        va_list vaArgList;
        va_start(vaArgList, format);
#if defined(HOST_WINDOWS)
        int ret = vsnprintf_s(destinationBuffer, destinationBufferSize, _TRUNCATE, format, vaArgList);
#else
        int ret = vsnprintf(destinationBuffer, destinationBufferSize, format, vaArgList);
        if (ret > 0 && static_cast<size_t>(ret) >= destinationBufferSize)
        {
            // Convert virtual buffer overrun to an error to match Windows
            // behavior.
            ret = -1;
        }
#endif
        destinationBuffer[destinationBufferSize - 1] = '\0';
        va_end(vaArgList);
        return ret;
    }

    int SafeStringConcatenate(char* destinationBuffer, size_t destinationBufferSize, const char* sourceBuffer)
    {
#ifdef HOST_WINDOWS
        return strcat_s(destinationBuffer, destinationBufferSize, sourceBuffer);
#else
        if (destinationBuffer != nullptr && sourceBuffer != nullptr && destinationBufferSize != 0)
        {
            for(size_t i = 0; i < destinationBufferSize; i++)
            {
                if(destinationBuffer[i] == '\0')
                {
                    return SafeStringCopy(destinationBuffer + i, destinationBufferSize - i, sourceBuffer);
                }
            }
        }
        return EINVAL;
#endif
    }

}
