/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
#include "stdafx.h"

#include "Internal_IndexList.h"

#include <cassert>
#include <cstdio>
#include <cstring>
#include "SafeString.h"

// When _TESTING_BUILD_ is defined in the Release configuration extra checks are added
// to some of the functions to make sure that we don't access past the bounds of the IndexList.
// #define _TESTING_BUILD_
#if defined(_TESTING_BUILD_) || defined(_DEBUG)
#define IL_ASSERTFAIL(text, ...) \
	std::cout << "IndexList Assertion failed: " << text << ", file " << __FILE__ << ", function " << __FUNCTION__ << ", line " << __LINE__ << std::endl; \
	assert(text && 0);\
	return __VA_ARGS__;

#define IL_ASSERT(condition, text, ...)	\
	if( !(condition) ) { \
	IL_ASSERTFAIL( text, __VA_ARGS__); \
}
#else
#define IL_ASSERT(condition, text, ...)	((void)0);
#define IL_ASSERTFAIL(text, ...)		((void)0);
#endif

IndexList* IndexList_Create(
    void
)
{
    auto indexList = new OpenIPC_IndexList();
    return indexList->GetCStruct();
}

IndexList* IndexList_CreateFromString(
    const char* string
)
{
	IL_ASSERT(string != nullptr, "The string pointer passed in is null.", NULL);

    auto indexList = new OpenIPC_IndexList(string);
    return indexList->GetCStruct();
}

void IndexList_Free(
    IndexList*  indexList
)
{
	IL_ASSERT(indexList != nullptr, "The IndexList pointer passed in is null.");
    delete reinterpret_cast<OpenIPC_IndexList*>(indexList);
}

bool IndexList_MoveNext(
    const IndexList*    indexList,
    IndexListIterator*  iterator
)
{
	IL_ASSERT(indexList != nullptr, "The IndexList pointer passed in is null.", false);
	IL_ASSERT(iterator != nullptr, "The IndexListIterator pointer passed in is null.", false);

    auto indexListImpl = reinterpret_cast<const OpenIPC_IndexList*>(indexList);
    if (!iterator->indexList)
    {
        iterator->indexList = indexList;
        iterator->position = 0;
    }
    else
    {
        ++iterator->position;
    }

    bool result;
    if (iterator->position < indexListImpl->GetLength())
    {
        iterator->index = indexListImpl->GetIndex(iterator->position);
        result = true;
    }
    else
    {
        iterator->index = uint64_t(-1);
        result = false;
    }

    return result;
}

void IndexList_Append(
    IndexList*  indexList,
    uint64_t     index
)
{
	IL_ASSERT(indexList != nullptr, "The IndexList pointer passed in is null.");

    auto indexListImpl = reinterpret_cast<OpenIPC_IndexList*>(indexList);
    indexListImpl->Append(index);
}

void IndexList_AppendRange(
    IndexList*  indexList,
    uint64_t     start,
    uint64_t     end
)
{
	IL_ASSERT(indexList != nullptr, "The IndexList pointer passed in is null.");

    auto indexListImpl = reinterpret_cast<OpenIPC_IndexList*>(indexList);
    indexListImpl->AppendRange(start, end);
}

void IndexList_ApplyOffset(
    IndexList*  indexList,
    uint64_t     offset
)
{
	IL_ASSERT(indexList != nullptr, "The IndexList pointer passed in is null.");

    auto indexListImpl = reinterpret_cast<OpenIPC_IndexList*>(indexList);
    indexListImpl->ApplyOffset(offset);
}

IndexList* IndexList_Slice(
    IndexList*  indexList,
    IndexList*  slice
)
{
	IL_ASSERT(indexList != nullptr, "The IndexList pointer passed in is null.", nullptr);
	IL_ASSERT(slice != nullptr, "The slice IndexList pointer passed in is null.", nullptr);

    const OpenIPC_IndexList& indexListImpl = *reinterpret_cast<OpenIPC_IndexList*>(indexList);
    const OpenIPC_IndexList& sliceImpl = *reinterpret_cast<OpenIPC_IndexList*>(slice);

    auto result = new OpenIPC_IndexList();
    *result = indexListImpl.Slice(sliceImpl);

    return result->GetCStruct();
}

void IndexList_Resize(
    IndexList*  indexList,
    size_t      length)
{
	IL_ASSERT(indexList != nullptr, "The IndexList pointer passed in is null.");

    auto indexListImpl = reinterpret_cast<OpenIPC_IndexList*>(indexList);
    indexListImpl->Resize(length);
}

uint64_t IndexList_GetIndex(
    const IndexList*    indexList,
    size_t              position
)
{
	IL_ASSERT(indexList != nullptr, "The IndexList pointer passed in is null.", (uint64_t)(-1));

    auto indexListImpl = reinterpret_cast<const OpenIPC_IndexList*>(indexList);
    return indexListImpl->GetIndex(position);
}

uint64_t IndexList_GetMaxIndex(
    const IndexList*    indexList
)
{
	IL_ASSERT(indexList != nullptr, "The IndexList pointer passed in is null.", 0);

    auto indexListImpl = reinterpret_cast<const OpenIPC_IndexList*>(indexList);
    return indexListImpl->GetMaxIndex();
}

uint64_t IndexList_GetMinIndex(
    const IndexList*    indexList
)
{
	IL_ASSERT(indexList != nullptr, "The IndexList pointer passed in is null.", 0);

    auto indexListImpl = reinterpret_cast<const OpenIPC_IndexList*>(indexList);
    return indexListImpl->GetMinIndex();
}

size_t IndexList_GetLength(
    const IndexList*    indexList
)
{
	IL_ASSERT(indexList != nullptr, "The IndexList pointer passed in is null.", 0);

    auto indexListImpl = reinterpret_cast<const OpenIPC_IndexList*>(indexList);
    return indexListImpl->GetLength();
}

bool IndexList_ExtractOffsetAndLength(
    const IndexList*    indexList,
    uint64_t*           offset,
    size_t*             length
)
{
    IL_ASSERT(indexList != nullptr, "The IndexList pointer passed in is null.", 0);
    IL_ASSERT(offset != nullptr, "The offset pointer passed in is null.", 0);
    IL_ASSERT(length != nullptr, "The length pointer passed in is null.", 0);

    auto indexListImpl = reinterpret_cast<const OpenIPC_IndexList*>(indexList);
    return indexListImpl->ExtractOffsetAndLength(*offset, *length);
}

size_t IndexList_GetStringSize(
    const IndexList*    indexList)
{
	IL_ASSERT(indexList != nullptr, "The IndexList pointer passed in is null.", 0);

    auto indexListImpl = reinterpret_cast<const OpenIPC_IndexList*>(indexList);
    std::string string = indexListImpl->ToString();

    return string.length();
}

void IndexList_ToString(
    const IndexList*    indexList,
    char*               buffer,
    size_t              bufferSize)
{
	IL_ASSERT(indexList != nullptr, "The IndexList pointer passed in is null.");
    IL_ASSERT(buffer != nullptr, "The buffer pointer passed in is null.");
    IL_ASSERT(bufferSize != 0, "The bufferSize passed in is 0.");

    auto indexListImpl = reinterpret_cast<const OpenIPC_IndexList*>(indexList);
    std::string string = indexListImpl->ToString();
    CommonUtils::SafeStringCopy(buffer, bufferSize, string);
}
