﻿/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
#pragma once

#include <vector>

#include <Foundation/Types.h>
#include <Foundation/BitData/BitData.h>

class JtagTdoHandler
{
    friend class JtagBypassBuilder;
    uint32_t _preBits;
    uint32_t _dataBits;
    uint32_t _postBits;
    uint32_t _verificationKey;
    uint32_t _additionalLowBitsToAdd;

public:
    JtagTdoHandler() : _preBits(0), _dataBits(0), _postBits(0), _verificationKey(0), _additionalLowBitsToAdd(0) {}

    void ExtractFromTdoBuffer(BitData* reg, const BitData* tdo, uint32_t offset = 0);

    bool IsVerificationKeyValid(const BitData* tdo, uint32_t offset = 0) const;
    bool HasVerification() const { return _verificationKey != 0; }
    void GetDataFieldInfo(uint32_t& offset, uint32_t& size) const { offset = _preBits; size = _dataBits; }
    uint32_t GetFullShiftLength() const { return _preBits + _dataBits + _postBits + ((_verificationKey != 0) ? 32 : 0); }
    void SetAdditionalLowBitsToAdd(uint32_t bitCount) { _additionalLowBitsToAdd = bitCount; }
    uint32_t GetAdditionalLowBitsToAdd() const { return _additionalLowBitsToAdd; }
};

class JtagBypassBuilder
{
private:
    uint32_t _totalIrLength;
    struct JtagDevice
    {
        uint32_t iroffset;
        uint32_t irlength;
    };
    std::vector<JtagDevice> _deviceList;
    uint32_t _irLowDeracers;
    uint32_t _irHighDeracers;
    uint32_t _drLowDeracers;
    uint32_t _drHighDeracers;
    bool _DrPadValue;

public:
    JtagBypassBuilder() : _totalIrLength(0), _irLowDeracers(0), _irHighDeracers(0), _drLowDeracers(0), _drHighDeracers(0), _DrPadValue(0) {}
    JtagBypassBuilder(uint32_t irLowDeracers, uint32_t irHighDeracers, uint32_t drLowDeracers, uint32_t drHighDeracers) : _totalIrLength(0), _irLowDeracers(irLowDeracers), _irHighDeracers(irHighDeracers), _drLowDeracers(drLowDeracers), _drHighDeracers(drHighDeracers), _DrPadValue(0) {}

    void SetDrPadValue(bool bOne) { _DrPadValue = bOne; }

    void AddDevice(uint32_t irlen, uint32_t offset);
    void RemoveDevice(uint32_t offset);
    void ClearDevices();

    uint32_t GetDeviceCount();
    uint32_t GetTotalIrLength();

    void GetPrePostBitCounts(uint32_t& msbs, uint32_t& lsbs, bool irNotDrScan, uint32_t devidx = -1) const;
    void GenerateTdiBuffer(bool irNotDrScan, BitData* tdi, const BitData* reg, uint32_t reglen = 0, uint32_t devidx = -1, uint32_t verificationKey = 0);
    void GetTdoHandler(JtagTdoHandler& tdoHandler, bool irNotDrScan, uint32_t reglen, uint32_t devidx = -1, uint32_t verificationKey = 0);
    void GetTdoHandlerForField(JtagTdoHandler& tdoHandler, bool irNotDrScan, uint32_t reglen, uint32_t regFieldStart, uint32_t regFieldLength, uint32_t devidx = -1, uint32_t verificationKey = 0, bool ignorePrePost = false);

    void AddToDrLowDeracers(uint32_t value);
    void AddToDrHighDeracers(uint32_t value);

	uint32_t GetDrLowDeracers() const;
	uint32_t GetDrHighDeracers() const;

private:
    void _resyncOffsets(uint32_t uptodevice);
};

void JtagShift(BitData* shift, uint32_t count, uint32_t offset, const uint8_t* tdi, uint8_t* tdo);






