﻿/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
#include <stdafx.h>

#include <Foundation/Types.h>

#include "TapStateMachine.h"

// this structure represents a TMS cycle, as expressed in a set of bits and a count of bits (note: there are no start->end state transitions that require more than 1 byte of TMS cycles)
typedef struct
{
	unsigned char tmsbits;
	unsigned char count;
} TmsCycle;

// this is the failsafe TMS cycle for going to TLR from ANY start state
// const TmsCycle _tmsGotoTlrFromUnknownState = {0x1f, 5}; // unused

// this is the complete set TMS cycles for going from any TAP state to any other TAP state, following the rules of the OpenIPC probe interface
const TmsCycle _tmsCycleLookup[][16] = 
{
/*   start*/ /*TLR      RTI      SelDR    CapDR    SDR      Ex1DR    PDR      Ex2DR    UpdDR    SelIR    CapIR    SIR      Ex1IR    PIR      Ex2IR    UpdIR    destination*/
/*     TLR*/{ {0x01,1},{0x00,1},{0x02,2},{0x02,3},{0x02,4},{0x0a,4},{0x0a,5},{0x2a,6},{0x1a,5},{0x06,3},{0x06,4},{0x06,5},{0x16,5},{0x16,6},{0x56,7},{0x36,6} },
/*     RTI*/{ {0x07,3},{0x00,1},{0x01,1},{0x01,2},{0x01,3},{0x05,3},{0x05,4},{0x15,5},{0x0d,4},{0x03,2},{0x03,3},{0x03,4},{0x0b,4},{0x0b,5},{0x2b,6},{0x1b,5} },
/*   SelDR*/{ {0x03,2},{0x03,3},{0x0b,4},{0x00,1},{0x00,2},{0x02,2},{0x02,3},{0x0a,4},{0x06,3},{0x01,1},{0x01,2},{0x01,3},{0x05,3},{0x05,4},{0x15,5},{0x0d,4} },
/*   CapDR*/{ {0x1f,5},{0x03,3},{0x07,3},{0x07,4},{0x00,1},{0x01,1},{0x01,2},{0x05,3},{0x03,2},{0x0f,4},{0x0f,5},{0x0f,6},{0x2f,6},{0x2f,7},{0xaf,8},{0x6f,7} },
/*     SDR*/{ {0x1f,5},{0x03,3},{0x07,3},{0x07,4},{0x07,5},{0x01,1},{0x01,2},{0x05,3},{0x03,2},{0x0f,4},{0x0f,5},{0x0f,6},{0x2f,6},{0x2f,7},{0xaf,8},{0x6f,7} },
/*   Ex1DR*/{ {0x0f,4},{0x01,2},{0x03,2},{0x03,3},{0x02,3},{0x0a,4},{0x00,1},{0x02,2},{0x01,1},{0x07,3},{0x07,4},{0x07,5},{0x17,5},{0x17,6},{0x57,7},{0x37,6} },
/*     PDR*/{ {0x1f,5},{0x03,3},{0x07,3},{0x07,4},{0x01,2},{0x05,3},{0x17,6},{0x01,1},{0x03,2},{0x0f,4},{0x0f,5},{0x0f,6},{0x2f,6},{0x2f,7},{0xaf,8},{0x6f,7} },
/*   Ex2DR*/{ {0x0f,4},{0x01,2},{0x03,2},{0x03,3},{0x00,1},{0x02,2},{0x02,3},{0x0a,4},{0x01,1},{0x07,3},{0x07,4},{0x07,5},{0x17,5},{0x17,6},{0x57,7},{0x37,6} },
/*   UpdDR*/{ {0x07,3},{0x00,1},{0x01,1},{0x01,2},{0x01,3},{0x05,3},{0x05,4},{0x15,5},{0x0d,4},{0x03,2},{0x03,3},{0x03,4},{0x0b,4},{0x0b,5},{0x2b,6},{0x1b,5} },
/*   SelIR*/{ {0x01,1},{0x01,2},{0x05,3},{0x05,4},{0x05,5},{0x15,5},{0x15,6},{0x55,7},{0x35,6},{0x0d,4},{0x00,1},{0x00,2},{0x02,2},{0x02,3},{0x0a,4},{0x06,3} },
/*   CapIR*/{ {0x1f,5},{0x03,3},{0x07,3},{0x07,4},{0x07,5},{0x17,5},{0x17,6},{0x57,7},{0x37,6},{0x0f,4},{0x0f,5},{0x00,1},{0x01,1},{0x01,2},{0x05,3},{0x03,2} },
/*     SIR*/{ {0x1f,5},{0x03,3},{0x07,3},{0x07,4},{0x07,5},{0x17,5},{0x17,6},{0x57,7},{0x37,6},{0x0f,4},{0x0f,5},{0x0f,6},{0x01,1},{0x01,2},{0x05,3},{0x03,2} },
/*   Ex1IR*/{ {0x0f,4},{0x01,2},{0x03,2},{0x03,3},{0x03,4},{0x0b,4},{0x0b,5},{0x2b,6},{0x1b,5},{0x07,3},{0x07,4},{0x02,3},{0x0a,4},{0x00,1},{0x02,2},{0x01,1} },
/*     PIR*/{ {0x1f,5},{0x03,3},{0x07,3},{0x07,4},{0x07,5},{0x17,5},{0x17,6},{0x57,7},{0x37,6},{0x0f,4},{0x0f,5},{0x01,2},{0x05,3},{0x2f,7},{0x01,1},{0x03,2} },
/*   Ex2IR*/{ {0x0f,4},{0x01,2},{0x03,2},{0x03,3},{0x03,4},{0x0b,4},{0x0b,5},{0x2b,6},{0x1b,5},{0x07,3},{0x07,4},{0x00,1},{0x02,2},{0x02,3},{0x0a,4},{0x01,1} },
/*   UpdIR*/{ {0x07,3},{0x00,1},{0x01,1},{0x01,2},{0x01,3},{0x05,3},{0x05,4},{0x15,5},{0x0d,4},{0x03,2},{0x03,3},{0x03,4},{0x0b,4},{0x0b,5},{0x2b,6},{0x1b,5} },
};

// This commented out function generated the table above
//void _GenTmsCycleLookupTable()
//{
//	TmsCycle _tmsCycleLookup[16][16] = {0};
//
//	for (uint8_t startstate = 0; startstate < 16; startstate++)
//	{
//		for (uint8_t size = 1; size <= 8; size++)
//		{
//			for (uint16_t byte = 0; byte < (1<<size); byte++)
//			{
//				TmsCycle tmscycle = {byte, size};
//				JtagStateEncode endstate = _walkTapStateMachine((JtagStateEncode)startstate, tmscycle);
//				
//				if (_tmsCycleLookup[startstate][endstate].count == 0)
//				{
//					if((startstate != endstate) || ((startstate != (uint8_t)JtagShfDR) && (startstate != (uint8_t)JtagShfIR) && (startstate != (uint8_t)JtagPauDR) && (startstate != (uint8_t)JtagPauIR)) || ((byte&3) == 3))
//					{
//						_tmsCycleLookup[startstate][endstate].count = size;
//						_tmsCycleLookup[startstate][endstate].tmsbits = byte;
//					}
//				}
//			}
//		}
//	}
//
//	printf("/*   start*/ /*TLR      RTI      SelDR    CapDR    SDR      Ex1DR    PDR      Ex2DR    UpdDR    SelIR    CapIR    SIR      Ex1IR    PIR      Ex2IR    UpdIR    destination*/\n");
//	for (uint8_t startstate = 0; startstate < 16; startstate++)
//	{
//		printf("/*%8s*/{ ", c_statestr[startstate]);
//		for (uint8_t endstate = 0; endstate < 16; endstate++)
//		{
//			printf("{0x%.2x,%d}", _tmsCycleLookup[startstate][endstate].tmsbits, _tmsCycleLookup[startstate][endstate].count);
//			if (endstate != 15)
//			{
//				printf(",");
//			}
//		}
//		printf(" },\n");
//	}
//}

// this is the full representation of the TAP state machine
const TapStateMachine::JtagStateEncode _tapStateMachineLookup[16][2] = {
/*start		TMS=0							TMS=1*/
/*TLR*/		{TapStateMachine::JtagRTI,		TapStateMachine::JtagTLR},
/*RTI*/		{TapStateMachine::JtagRTI,		TapStateMachine::JtagSelDR},
/*SelDR*/	{TapStateMachine::JtagCapDR,	TapStateMachine::JtagSelIR},
/*CapDR*/	{TapStateMachine::JtagShfDR,	TapStateMachine::JtagEx1DR},
/*SDR*/		{TapStateMachine::JtagShfDR,	TapStateMachine::JtagEx1DR},
/*Ex1DR*/	{TapStateMachine::JtagPauDR,	TapStateMachine::JtagUpdDR},
/*PDR*/		{TapStateMachine::JtagPauDR,	TapStateMachine::JtagEx2DR},
/*Ex2DR*/	{TapStateMachine::JtagShfDR,	TapStateMachine::JtagUpdDR},
/*UpdDR*/	{TapStateMachine::JtagRTI,		TapStateMachine::JtagSelDR},
/*SelIR*/	{TapStateMachine::JtagCapIR,	TapStateMachine::JtagTLR},
/*CapIR*/	{TapStateMachine::JtagShfIR,	TapStateMachine::JtagEx1IR},
/*SIR*/		{TapStateMachine::JtagShfIR,	TapStateMachine::JtagEx1IR},
/*Ex1IR*/	{TapStateMachine::JtagPauIR,	TapStateMachine::JtagUpdIR},
/*PIR*/		{TapStateMachine::JtagPauIR,	TapStateMachine::JtagEx2IR},
/*Ex2IR*/	{TapStateMachine::JtagShfIR,	TapStateMachine::JtagUpdIR},
/*UpdIR*/	{TapStateMachine::JtagRTI,		TapStateMachine::JtagSelDR},
};

void TapStateMachine::DriveTmsCycles(uint8_t* tmsbits, uint32_t count)
{
	for (uint32_t tck = 0; tck < count; tck++)
	{
		_state = _tapStateMachineLookup[_state][(tmsbits[tck>>3]>>(tck&0x7))&1];
	}
}

void TapStateMachine::DriveTmsCycles(unsigned char tmsbits, unsigned char count)
{
	for (int tck = 0; tck < count; tck++)
	{
		_state = _tapStateMachineLookup[_state][tmsbits&1];
		tmsbits >>= 1;
	}
}

void TapStateMachine::DriveTmsCycle(bool tms)
{
	_state = _tapStateMachineLookup[_state][tms&1];
}

void TapStateMachine::GetTmsCycles(JtagStateEncode dest_state, unsigned char& tmsbits, unsigned char& count)
{
	const TmsCycle& tmsCycle = _tmsCycleLookup[_state][dest_state];
	tmsbits = tmsCycle.tmsbits;
	count = tmsCycle.count;
}








