/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
#pragma once

class TapStateMachine
{
public:
	// note: these enumeration values comply with SVF/XSVF standards (so don't change them!)
	enum JtagStateEncode
	{
		JtagTLR		= 0x00,
		JtagRTI		= 0x01,
		JtagSelDR	= 0x02,
		JtagCapDR	= 0x03,
		JtagShfDR	= 0x04,
		JtagEx1DR	= 0x05,
		JtagPauDR	= 0x06,
		JtagEx2DR	= 0x07,
		JtagUpdDR	= 0x08,
		JtagSelIR	= 0x09,
		JtagCapIR	= 0x0A,
		JtagShfIR	= 0x0B,
		JtagEx1IR	= 0x0C,
		JtagPauIR	= 0x0D,
		JtagEx2IR	= 0x0E,
		JtagUpdIR	= 0x0F
	};

private:
	JtagStateEncode _state;

public:
	TapStateMachine(JtagStateEncode start_state = JtagTLR) : _state(start_state) {};

	inline JtagStateEncode GetState() {return _state;}
	inline void SetState(JtagStateEncode new_state){_state = new_state;}

	void DriveTmsCycles(uint8_t* tmsbits, uint32_t count);
	void DriveTmsCycles(unsigned char tmsbits, unsigned char count);
	void DriveTmsCycle(bool tms);
	void GetTmsCycles(JtagStateEncode dest_state, unsigned char& tmsbits, unsigned char& count);
};
