set(Public_Include_Headers "../../Public_Include/Foundation/Logging/Logging.h"
                           "../../Public_Include/Foundation/Logging/LoggingTypes.h"
						               "../../Public_Include/Foundation/Logging/LoggingMacros.h"
                           "../../Public_Include/Foundation/Logging/OpenIPC_Logger.h")

set(HeaderFiles_Headers "OpenIPCLogger.h"
                        "stdafx.h")

set(SourceFiles_Sources "LoggingImpl.cpp"
                        "OpenIPCLogger.cpp")

ADD_PRECOMPILED_HEADER("stdafx.h" "stdafx.cpp" SourceFiles_Sources)

FILE(GLOB CMakeIncludes CMakeIncludes//*.cmake)

source_group("CMake Includes" FILES ${CMakeIncludes})
source_group("Public_Include" FILES ${Public_Include_Headers} )
source_group("Header Files" FILES ${HeaderFiles_Headers} )
source_group("Source Files" FILES ${SourceFiles_Sources} )

# Store all sources in SOURCES variable
set(SOURCES ${SOURCES} ${Public_Include_Headers} ${HeaderFiles_Headers} ${SourceFiles_Sources} ${CMakeIncludes})

ShipSources(FILES ${SOURCES} CMakeLists.txt)

if(WIN32)
    configure_file(
      ${MAIN_ROOT}/${INCLUDE_DIR}/resource_template.rc
      ${CMAKE_CURRENT_BINARY_DIR}/Generated/resource.rc
      @ONLY)

    set(ResourceFiles "./Generated/resource.rc")
    source_group("Resource Files" FILES ${ResourceFiles})
    set(SOURCES ${SOURCES} ${ResourceFiles})
endif()
