/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
#pragma once

///
/// @brief A processing instruction in a document.
class STRUCTUREDDATA_API DataProcessingInstruction
{
	friend class DataDocument;

private:
	unsigned _lineNumber;
	DataDocument* _doc;
	std::string _target;
	std::string _data;
	size_t _position;

	DataProcessingInstruction(const std::string& target, const std::string& data, size_t position, DataDocument* doc)
		: _lineNumber(0), _doc(doc), _target(target), _data(data), _position(position)
	{
	}

public:
	const std::string& Target() const;

	const std::string& Data() const;

	///
	/// @brief Gets the line number that the processing instruction was loaded from.
	unsigned LineNumber() const;

	///
	/// @brief Sets the line number that the processing instruction was loaded from.
	///
	/// @param lineNumber
	///		The line number that the processing instruction was loaded from.
	void SetLineNumber(unsigned lineNumber);
	
    ///
    /// @brief Gets the position of the processing instruction.
    size_t Position() const;
	
    ///
    /// @brief Gets the next processing instruction in the file.
    ///
    /// @returns The next processing instruction; null if there 
	/// is no next processing instruction.
    DataProcessingInstruction* NextSibling() const;
};