/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////
#pragma once

#include "XmlParser.h"

#include <PushNewOverride.h>
#include <xercesc/dom/DOM.hpp>
#include <xercesc/framework/XMLGrammarPool.hpp>
#include <xercesc/sax/InputSource.hpp>
#include <xercesc/framework/XMLFormatter.hpp>
#include <PopNewOverride.h>

class XercesGrammarPool : public GrammarPool
{
public:
    XercesGrammarPool();
    ~XercesGrammarPool();

    void LoadSchemaDirectory(const std::string& directoryPath) override;
    void LoadSchemaFile(const std::string& filePath) override;
    xercesc::XMLGrammarPool* GetXercesGrammarPool() const { return xercesPool.get(); }

private:
    void ParseGrammarContent(const std::vector<std::string>& filePaths);

    class PoolUnlocker
    {
    public:
        PoolUnlocker(xercesc::XMLGrammarPool* pool)
            : _pool(pool)
        {
            _pool->unlockPool();
        }

        ~PoolUnlocker()
        {
            _pool->lockPool();
        }

    private:
        xercesc::XMLGrammarPool* _pool;
    };

private:
    std::unique_ptr<xercesc::XMLGrammarPool> xercesPool;
};

// A thin layer around Xerces.
class XercesParser : public XmlParser
{
public:
    XercesParser() : XmlParser() {}
    ~XercesParser() {}

    void LoadXmlFile(DataDocument* doc, const std::string& filePath, bool enableSchemaValidation) const override;
    void LoadXmlFile(DataDocument* doc, const std::string& filePath, const GrammarPool& grammarPool) const override;
    void LoadXmlString(DataDocument* doc, const std::string& xml) const override;

    void SaveXmlFile(const DataDocument* doc, const std::string& filePath) const override;
    std::string SaveXmlString(const DataDocument* doc) const override;

private:
    void _ConvertToXerces(const DataElement* element, xercesc::DOMDocument* doc, xercesc::DOMElement* xercesElement) const;
    void _LoadXml(DataElement* element, const std::string& filePath, const xercesc::InputSource& source, bool enableSchemaValidation, xercesc::XMLGrammarPool* grammarPool) const;
    void _SaveXml(const DataElement* element, xercesc::XMLFormatTarget& target) const;
};
