﻿/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

#include "stdafx.h"
#include "Foundation/Telemetry/Telemetry.h"

#include "Foundation/Logging/OpenIPC_Logger.h"

static std::unique_ptr<OpenIPC_Logger> _logger(OpenIPC_Logger::GetLogger(OpenIPC_LoggingLoggerId::OpenIPC_LoggingLoggerId_Telemetry));

EXPORT_TELEMETRY_API void Telemetry_Initialize(const char* appname, const char* appver)
{
	OpenIPC_LOG(_logger, OpenIPC_LoggingSeverityLevel_Trace, "Initialize(appname=" << LOG_STRING(appname) << " appver=" << LOG_STRING(appver) << ")");
}

EXPORT_TELEMETRY_API void Telemetry_Deinitialize()
{
	OpenIPC_LOG(_logger, OpenIPC_LoggingSeverityLevel_Trace, "Deinitialize()");
}

EXPORT_TELEMETRY_API void Telemetry_BeginSession(const char* sessionname)
{
	OpenIPC_LOG(_logger, OpenIPC_LoggingSeverityLevel_Trace, "BeginSession(sessionname=" << LOG_STRING(sessionname) << ")");
}

EXPORT_TELEMETRY_API void Telemetry_EndSession(const char* sessionname)
{
 	OpenIPC_LOG(_logger, OpenIPC_LoggingSeverityLevel_Trace, "EndSession(sessionname=" << LOG_STRING(sessionname) << ")");
}

EXPORT_TELEMETRY_API void Telemetry_SendEvent(const char* sessionname, const char* eventname)
{
	OpenIPC_LOG(_logger, OpenIPC_LoggingSeverityLevel_Trace, "SendEvent(sessionname=" << LOG_STRING(sessionname) << " eventname=" << LOG_STRING(eventname) << ")");
}

EXPORT_TELEMETRY_API void Telemetry_BuildDataSet(const char* eventname, const char* key, const char* value, bool encrypt)
{
	OpenIPC_LOG(_logger, OpenIPC_LoggingSeverityLevel_Trace, "BuildDataSet(eventname=" << LOG_STRING(eventname) << " key=" << LOG_STRING(key) << " value=" << LOG_STRING(value) << " encrypt=" << LOG_BOOL(encrypt) << ")");
}

EXPORT_TELEMETRY_API bool Telemetry_HasDataSet(const char* eventname)
{
	OpenIPC_LOG(_logger, OpenIPC_LoggingSeverityLevel_Trace, "Telemetry_HasDataSet(eventname=" << LOG_STRING(eventname) << ")");

	return false;
}

EXPORT_TELEMETRY_API void Telemetry_DiscardDataSet(const char* eventname)
{
	OpenIPC_LOG(_logger, OpenIPC_LoggingSeverityLevel_Trace, "DiscardDataSet(eventname=" << LOG_STRING(eventname) << ")");
}

EXPORT_TELEMETRY_API void Telemetry_UploadFile(const char* sessionname, const char* eventname, const char* friendlyfilename, const char* filepath)
{
	OpenIPC_LOG(_logger, OpenIPC_LoggingSeverityLevel_Trace, "UploadFile(sessionname=" << LOG_STRING(sessionname) << " eventname=" << LOG_STRING(eventname) << "friendlyfilename=" << LOG_STRING(friendlyfilename) << " filepath=" << LOG_STRING(filepath) << ")");
}

EXPORT_TELEMETRY_API void Telemetry_CountEvent(const char* sessionname, const char* eventname, const char* key, const char* value)
{
    OpenIPC_LOG(_logger, OpenIPC_LoggingSeverityLevel_Trace, "CountEvent(sessionname=" << LOG_STRING(sessionname) << " eventname=" << LOG_STRING(eventname) << "key=" << LOG_STRING(key) << " value=" << LOG_STRING(value) << ")");
}
