/////////////////////////<Source Code Embedded Notices>/////////////////////////
//
// INTEL CONFIDENTIAL
// Copyright (C) Intel Corporation All Rights Reserved.
//
// The source code contained or described herein and all documents related to
// the source code ("Material") are owned by Intel Corporation or its suppliers
// or licensors. Title to the Material remains with Intel Corporation or its
// suppliers and licensors. The Material contains trade secrets and proprietary
// and confidential information of Intel or its suppliers and licensors. The
// Material is protected by worldwide copyright and trade secret laws and
// treaty provisions. No part of the Material may be used, copied, reproduced,
// modified, published, uploaded, posted, transmitted, distributed, or disclosed
// in any way without Intel's prior express written permission.
//
// No license under any patent, copyright, trade secret or other intellectual
// property right is granted to or conferred upon you by disclosure or delivery
// of the Materials, either expressly, by implication, inducement, estoppel or
// otherwise. Any license under such intellectual property rights must be
// express and approved by Intel in writing.
//
/////////////////////////<Source Code Embedded Notices>/////////////////////////

#pragma once

typedef struct
{
	unsigned bytecnt		: 21; // 21-bits of byte count (keep max payload on a single scan the same as JTAG, 2MBytes)
	unsigned devid			: 7;  // upper 7-bits of the first byte after start/repeated-start
	unsigned read			: 1;  // 1-bit of read (not write)... the LSB of the first byte after start/repeated-start
	unsigned reserved		: 1;  // 1-bit undefined, reserved for future use
	unsigned forcestop		: 1;  // 1-bit indicating a stop/start should be forced between this scan and the next in a lock sequence (otherwise a repeated-start is used between transactions)
	unsigned metaop			: 1;  // 1-bit indicates a metaoperation (vs a scan)... this should be 0
} I2cDwordEncodeDescriptor;

// writeback data format rules:
//	1. all ACKs from the slave for either address/control or written data bytes result in 1 full byte of ACK result, bit[0] = ACK/!NACK, bit[7:1] = 0
//	2. bytes read from the slave will show up in order, with acks bytes from address/control or writes
